/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.auth.oauth2.Oauth2Credentials;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;

public class Oauth2CredentialsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, Oauth2Credentials obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "assertion": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAssertion((String)member.getValue());
                    break;
                }
                case "code": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCode((String)member.getValue());
                    break;
                }
                case "codeVerifier": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCodeVerifier((String)member.getValue());
                    break;
                }
                case "jwt": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJwt(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "redirectUri": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRedirectUri((String)member.getValue());
                    break;
                }
                case "scopes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<String> list = new ArrayList<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setScopes(list);
                    break;
                }
                case "username": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUsername((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(Oauth2Credentials obj, JsonObject json) {
        Oauth2CredentialsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(Oauth2Credentials obj, Map<String, Object> json) {
        if (obj.getAssertion() != null) {
            json.put("assertion", obj.getAssertion());
        }
        if (obj.getCode() != null) {
            json.put("code", obj.getCode());
        }
        if (obj.getCodeVerifier() != null) {
            json.put("codeVerifier", obj.getCodeVerifier());
        }
        if (obj.getJwt() != null) {
            json.put("jwt", obj.getJwt());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        if (obj.getRedirectUri() != null) {
            json.put("redirectUri", obj.getRedirectUri());
        }
        if (obj.getScopes() != null) {
            JsonArray array = new JsonArray();
            obj.getScopes().forEach(item -> array.add(item));
            json.put("scopes", array);
        }
        if (obj.getUsername() != null) {
            json.put("username", obj.getUsername());
        }
    }
}

