/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.OAuth2Response;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;
import java.io.UnsupportedEncodingException;
import java.util.Base64;

abstract class AbstractOAuth2Flow
implements OAuth2Flow {
    protected final Vertx vertx;
    protected final OAuth2ClientOptions config;

    AbstractOAuth2Flow(Vertx vertx, OAuth2ClientOptions config) {
        this.vertx = vertx;
        this.config = config;
    }

    static void throwIfNull(String key, Object value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Configuration missing. You need to specify [" + key + "]");
        }
    }

    void getToken(String grantType, JsonObject params, Handler<AsyncResult<JsonObject>> handler) {
        JsonObject tmp;
        boolean confidentialClient;
        JsonObject headers = new JsonObject();
        boolean bl = confidentialClient = this.config.getClientID() != null && this.config.getClientSecret() != null;
        if (confidentialClient) {
            String basic = this.config.getClientID() + ":" + this.config.getClientSecret();
            headers.put("Authorization", "Basic " + Base64.getEncoder().encodeToString(basic.getBytes()));
        }
        if ((tmp = this.config.getHeaders()) != null) {
            headers.mergeIn(tmp);
        }
        JsonObject form = params.copy();
        if (this.config.getExtraParameters() != null) {
            form.mergeIn(this.config.getExtraParameters());
        }
        form.put("grant_type", grantType);
        if (!confidentialClient) {
            form.put("client_id", this.config.getClientID());
            if (this.config.getClientSecretParameterName() != null) {
                form.put(this.config.getClientSecretParameterName(), this.config.getClientSecret());
            }
        }
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Buffer payload = Buffer.buffer((String)OAuth2API.stringify(form));
        headers.put("Accept", "application/json,application/x-www-form-urlencoded;q=0.9");
        OAuth2API.fetch(this.vertx, this.config, HttpMethod.POST, this.config.getTokenPath(), headers, payload, (Handler<AsyncResult<OAuth2Response>>)((Handler)res -> {
            block17: {
                JsonObject json;
                if (res.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                    return;
                }
                OAuth2Response reply = (OAuth2Response)res.result();
                if (reply.body() == null || reply.body().length() == 0) {
                    handler.handle((Object)Future.failedFuture((String)"No Body"));
                    return;
                }
                if (reply.is("application/json")) {
                    try {
                        json = reply.jsonObject();
                    }
                    catch (RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else if (reply.is("application/x-www-form-urlencoded") || reply.is("text/plain")) {
                    try {
                        json = OAuth2API.queryToJSON(reply.body().toString());
                    }
                    catch (UnsupportedEncodingException | RuntimeException e) {
                        handler.handle((Object)Future.failedFuture((Throwable)e));
                        return;
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((String)("Cannot handle content type: " + reply.headers().get("Content-Type"))));
                    return;
                }
                try {
                    if (json.containsKey("error")) {
                        String description;
                        Object error = json.getValue("error");
                        if (error instanceof JsonObject) {
                            description = ((JsonObject)error).getString("message");
                        } else {
                            try {
                                description = json.getString("error_description", json.getString("error"));
                            }
                            catch (RuntimeException e) {
                                description = error.toString();
                            }
                        }
                        handler.handle((Object)Future.failedFuture((String)description));
                        break block17;
                    }
                    handler.handle((Object)Future.succeededFuture((Object)json));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            }
        }));
    }
}

