/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.auth.oauth2.impl.flow.AbstractOAuth2Flow;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class ClientImpl
extends AbstractOAuth2Flow
implements OAuth2Flow {
    public ClientImpl(OAuth2AuthProviderImpl provider) {
        super(provider);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        this.getToken("client_credentials", params, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            OAuth2TokenImpl token;
            if (res.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                return;
            }
            try {
                token = new OAuth2TokenImpl(this.provider, (JsonObject)res.result());
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
                return;
            }
            handler.handle((Object)Future.succeededFuture((Object)token));
        }));
    }
}

