/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.OAuth2ClientOptions;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

abstract class CommonFlow
implements OAuth2Flow {
    protected final OAuth2AuthProviderImpl provider;
    protected final OAuth2ClientOptions config;

    CommonFlow(OAuth2AuthProviderImpl provider) {
        this.provider = provider;
        this.config = provider.getConfig();
    }

    @Override
    public void introspectToken(String token, String tokenType, Handler<AsyncResult<JsonObject>> handler) {
        JsonObject query = new JsonObject().put("token", token).put("authorizationHeaderOnly", Boolean.valueOf(true));
        if (tokenType != null) {
            query.put("token_type_hint", tokenType);
        }
        OAuth2API.api(this.provider, HttpMethod.POST, this.config.getIntrospectionPath(), query, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                try {
                    JsonObject json = (JsonObject)res.result();
                    if (json.containsKey("active") && !json.getBoolean("active", Boolean.valueOf(false)).booleanValue()) {
                        handler.handle((Object)Future.failedFuture((String)"Inactive Token"));
                        return;
                    }
                    if (json.containsKey("client_id") && !json.getString("client_id", "").equals(this.config.getClientID())) {
                        handler.handle((Object)Future.failedFuture((String)"Wrong client_id"));
                        return;
                    }
                    handler.handle((Object)Future.succeededFuture((Object)res.result()));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }
}

