/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2.impl.flow;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.oauth2.AccessToken;
import io.vertx.ext.auth.oauth2.impl.AccessTokenImpl;
import io.vertx.ext.auth.oauth2.impl.OAuth2API;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;
import io.vertx.ext.auth.oauth2.impl.flow.CommonFlow;
import io.vertx.ext.auth.oauth2.impl.flow.OAuth2Flow;

public class ClientImpl
extends CommonFlow
implements OAuth2Flow {
    public ClientImpl(OAuth2AuthProviderImpl provider) {
        super(provider);
    }

    @Override
    public void getToken(JsonObject params, Handler<AsyncResult<AccessToken>> handler) {
        JsonObject query = params.copy();
        query.put("grant_type", "client_credentials");
        JsonObject extraParameters = this.provider.getConfig().getExtraParameters();
        if (extraParameters != null) {
            query.mergeIn(extraParameters);
        }
        OAuth2API.api(this.provider, HttpMethod.POST, this.provider.getConfig().getTokenPath(), query, (Handler<AsyncResult<JsonObject>>)((Handler)res -> {
            if (res.succeeded()) {
                try {
                    handler.handle((Object)Future.succeededFuture((Object)new AccessTokenImpl(this.provider, (JsonObject)res.result())));
                }
                catch (RuntimeException e) {
                    handler.handle((Object)Future.failedFuture((Throwable)e));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            }
        }));
    }
}

