/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.auth.oauth2;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.ext.auth.User;
import rx.Observable;

public class AccessToken
extends User {
    final io.vertx.ext.auth.oauth2.AccessToken delegate;

    public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
        super((io.vertx.ext.auth.User)delegate);
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public AccessToken refresh(final Handler<AsyncResult<Void>> callback) {
        this.delegate.refresh(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<Void> refreshObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.refresh((Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public AccessToken revoke(String token_type, final Handler<AsyncResult<Void>> callback) {
        this.delegate.revoke(token_type, new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<Void> revokeObservable(String token_type) {
        ObservableFuture callback = RxHelper.observableFuture();
        this.revoke(token_type, (Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public AccessToken logout(final Handler<AsyncResult<Void>> callback) {
        this.delegate.logout(new Handler<AsyncResult<Void>>(){

            public void handle(AsyncResult<Void> ar) {
                if (ar.succeeded()) {
                    callback.handle((Object)Future.succeededFuture((Object)ar.result()));
                } else {
                    callback.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Observable<Void> logoutObservable() {
        ObservableFuture callback = RxHelper.observableFuture();
        this.logout((Handler<AsyncResult<Void>>)callback.toHandler());
        return callback;
    }

    public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
        return arg != null ? new AccessToken(arg) : null;
    }
}

