/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.authorization.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.jwt.authorization.JWTAuthorization;
import java.util.HashSet;
import java.util.Objects;

public class JWTAuthorizationImpl
implements JWTAuthorization {
    private final String rootClaim;

    public JWTAuthorizationImpl(String rootClaim) {
        this.rootClaim = Objects.requireNonNull(rootClaim, "rootClaim cannot be null");
    }

    public String getId() {
        return "jwt";
    }

    public Future<Void> getAuthorizations(User user) {
        JsonArray roles;
        if (this.rootClaim.contains("/")) {
            try {
                roles = JWTAuthorizationImpl.getNestedJsonValue(user.attributes().getJsonObject("accessToken"), this.rootClaim);
            }
            catch (RuntimeException e) {
                return Future.failedFuture((Throwable)e);
            }
        }
        try {
            roles = user.attributes().getJsonObject("accessToken").getJsonArray(this.rootClaim);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        HashSet<PermissionBasedAuthorization> authorizations = new HashSet<PermissionBasedAuthorization>();
        if (roles != null && roles.size() >= 0) {
            for (Object el : roles) {
                if (el instanceof String) {
                    authorizations.add(PermissionBasedAuthorization.create((String)((String)el)));
                    continue;
                }
                return Future.failedFuture((String)("Cannot parse role: " + el));
            }
        }
        user.authorizations().put(this.getId(), authorizations);
        return Future.succeededFuture();
    }

    private static @Nullable JsonArray getNestedJsonValue(JsonObject jwtToken, String permissionsClaimKey) {
        String[] keys = permissionsClaimKey.split("/");
        JsonObject obj = null;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                obj = jwtToken.getJsonObject(keys[i]);
                continue;
            }
            if (i == keys.length - 1) {
                if (obj == null) continue;
                return obj.getJsonArray(keys[i]);
            }
            if (obj == null) continue;
            obj = obj.getJsonObject(keys[i]);
        }
        return null;
    }
}

