/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.TokenCredentials;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.PermissionBasedAuthorization;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWT;
import io.vertx.ext.auth.jwt.JWTAuth;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JWTAuthProviderImpl
implements JWTAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private final JWT jwt = new JWT();
    private final String permissionsClaimKey;
    private final JWTOptions jwtOptions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public JWTAuthProviderImpl(Vertx vertx, JWTAuthOptions config) {
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.jwtOptions = config.getJWTOptions();
        KeyStoreOptions keyStore = config.getKeyStore();
        try {
            List<JsonObject> jwks;
            List<PubSecKeyOptions> keys;
            block19: {
                KeyStore ks;
                block17: {
                    Throwable throwable;
                    ByteArrayInputStream in;
                    block18: {
                        if (keyStore == null) break block19;
                        ks = KeyStore.getInstance(keyStore.getType());
                        Iterator iterator = JWTAuthProviderImpl.class;
                        // MONITORENTER : io.vertx.ext.auth.jwt.impl.JWTAuthProviderImpl.class
                        Buffer keystore = vertx.fileSystem().readFileBlocking(keyStore.getPath());
                        in = new ByteArrayInputStream(keystore.getBytes());
                        throwable = null;
                        ks.load(in, keyStore.getPassword().toCharArray());
                        if (in == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ((InputStream)in).close();
                    break block17;
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (in == null) throw throwable4;
                            if (throwable == null) {
                                ((InputStream)in).close();
                                throw throwable4;
                            }
                            try {
                                ((InputStream)in).close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                                throw throwable4;
                            }
                        }
                    }
                }
                // MONITOREXIT : iterator
                for (JWK key : JWK.load((KeyStore)ks, (String)keyStore.getPassword(), (Map)keyStore.getPasswordProtection())) {
                    this.jwt.addJWK(key);
                }
            }
            if ((keys = config.getPubSecKeys()) != null) {
                for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                    this.jwt.addJWK(new JWK(pubSecKey));
                }
            }
            if ((jwks = config.getJwks()) == null) return;
            Iterator<JsonObject> iterator = jwks.iterator();
            while (iterator.hasNext()) {
                JsonObject jwk = iterator.next();
                this.jwt.addJWK(new JWK(jwk));
            }
            return;
        }
        catch (FileSystemException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new TokenCredentials(authInfo.getString("jwt")), resultHandler);
    }

    public void authenticate(Credentials credentials, Handler<AsyncResult<User>> resultHandler) {
        try {
            TokenCredentials authInfo = (TokenCredentials)credentials;
            authInfo.checkValid(null);
            JsonObject payload = this.jwt.decode(authInfo.getToken());
            if (this.jwt.isExpired(payload, this.jwtOptions)) {
                resultHandler.handle((Object)Future.failedFuture((String)"Expired JWT token."));
                return;
            }
            if (this.jwtOptions.getAudience() != null) {
                JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                    resultHandler.handle((Object)Future.failedFuture((String)("Invalid JWT audient. expected: " + Json.encode((Object)this.jwtOptions.getAudience()))));
                    return;
                }
            }
            if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT issuer"));
                return;
            }
            if (!this.jwt.isScopeGranted(payload, this.jwtOptions)) {
                resultHandler.handle((Object)Future.failedFuture((String)"Invalid JWT token: missing required scopes."));
                return;
            }
            resultHandler.handle((Object)Future.succeededFuture((Object)User.create((JsonObject)payload)));
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject _claims = claims.copy();
        if (options.getPermissions() != null && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, (Object)new JsonArray(options.getPermissions()));
        }
        return this.jwt.sign(_claims, options);
    }

    private static JsonArray getJsonPermissions(JsonObject jwtToken, String permissionsClaimKey) {
        if (permissionsClaimKey.contains("/")) {
            return JWTAuthProviderImpl.getNestedJsonValue(jwtToken, permissionsClaimKey);
        }
        return jwtToken.getJsonArray(permissionsClaimKey, null);
    }

    private User createUser(JsonObject jwtToken, String permissionsClaimKey) {
        User result = User.create((JsonObject)jwtToken);
        JsonArray jsonPermissions = JWTAuthProviderImpl.getJsonPermissions(jwtToken, permissionsClaimKey);
        if (jsonPermissions != null) {
            for (Object item : jsonPermissions) {
                if (!(item instanceof String)) continue;
                String permission = (String)item;
                result.authorizations().add("jwt-authentication", (Authorization)PermissionBasedAuthorization.create((String)permission));
            }
        }
        return result;
    }

    private static JsonArray getNestedJsonValue(JsonObject jwtToken, String permissionsClaimKey) {
        String[] keys = permissionsClaimKey.split("/");
        JsonObject obj = null;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                obj = jwtToken.getJsonObject(keys[i]);
                continue;
            }
            if (i == keys.length - 1) {
                if (obj == null) continue;
                return obj.getJsonArray(keys[i]);
            }
            if (obj == null) continue;
            obj = obj.getJsonObject(keys[i]);
        }
        return null;
    }
}

