/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt.authorization.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.auth.jwt.authorization.JWTAuthorization;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class JWTAuthorizationImpl
implements JWTAuthorization {
    private final String rootClaim;

    public JWTAuthorizationImpl(String rootClaim) {
        this.rootClaim = Objects.requireNonNull(rootClaim, "rootClaim cannot be null");
    }

    public String getId() {
        return "jwt";
    }

    public void getAuthorizations(User user, Handler<AsyncResult<Set<Authorization>>> handler) {
        JsonArray roles;
        if (this.rootClaim.contains("/")) {
            try {
                roles = JWTAuthorizationImpl.getNestedJsonValue(user.principal(), this.rootClaim);
            }
            catch (RuntimeException e) {
                handler.handle((Object)Future.failedFuture((Throwable)e));
                return;
            }
        }
        try {
            roles = user.principal().getJsonArray(this.rootClaim);
        }
        catch (RuntimeException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
            return;
        }
        HashSet<RoleBasedAuthorization> authorizations = new HashSet<RoleBasedAuthorization>();
        if (roles != null && roles.size() >= 0) {
            for (Object el : roles) {
                if (el instanceof String) {
                    authorizations.add(RoleBasedAuthorization.create((String)((String)el)));
                    continue;
                }
                handler.handle((Object)Future.failedFuture((String)("Cannot parse role: " + el)));
                return;
            }
        }
        handler.handle((Object)Future.succeededFuture(authorizations));
    }

    private static JsonArray getNestedJsonValue(JsonObject jwtToken, String permissionsClaimKey) {
        String[] keys = permissionsClaimKey.split("/");
        JsonObject obj = null;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                obj = jwtToken.getJsonObject(keys[i]);
                continue;
            }
            if (i == keys.length - 1) {
                if (obj == null) continue;
                return obj.getJsonArray(keys[i]);
            }
            if (obj == null) continue;
            obj = obj.getJsonObject(keys[i]);
        }
        return null;
    }
}

