/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import java.util.ArrayList;
import java.util.Map;

public class JWTAuthOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, JWTAuthOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "jwks": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<JsonObject> list = new ArrayList<JsonObject>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(((JsonObject)item).copy());
                        }
                    });
                    obj.setJwks(list);
                    break;
                }
                case "jwtOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setJWTOptions(new JWTOptions((JsonObject)member.getValue()));
                    break;
                }
                case "keyStore": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setKeyStore(new KeyStoreOptions((JsonObject)member.getValue()));
                    break;
                }
                case "permissionsClaimKey": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPermissionsClaimKey((String)member.getValue());
                    break;
                }
                case "pubSecKeys": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<JsonObject> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((JsonObject)new PubSecKeyOptions((JsonObject)item));
                        }
                    });
                    obj.setPubSecKeys(list);
                    break;
                }
                case "secrets": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<JsonObject> list = new ArrayList();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add((JsonObject)new SecretOptions((JsonObject)item));
                        }
                    });
                    obj.setSecrets(list);
                }
            }
        }
    }

    public static void toJson(JWTAuthOptions obj, JsonObject json) {
        JWTAuthOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(JWTAuthOptions obj, Map<String, Object> json) {
        if (obj.getJwks() != null) {
            JsonArray array = new JsonArray();
            obj.getJwks().forEach(item -> array.add(item));
            json.put("jwks", array);
        }
        if (obj.getPermissionsClaimKey() != null) {
            json.put("permissionsClaimKey", obj.getPermissionsClaimKey());
        }
    }
}

