/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptionsConverter;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class JWTAuthOptions {
    private static final String PERMISSIONS_CLAIM_KEY = "permissions";
    private static final boolean IGNORE_EXPIRATION = false;
    private static final int LEEWAY = 0;
    private String permissionsClaimKey;
    private KeyStoreOptions keyStore;
    private List<PubSecKeyOptions> pubSecKeys;
    private List<SecretOptions> secrets;
    private List<String> audience;
    private String issuer;
    private boolean ignoreExpiration;
    private int leeway;

    public JWTAuthOptions() {
        this.init();
    }

    public JWTAuthOptions(JWTAuthOptions other) {
        this.permissionsClaimKey = other.getPermissionsClaimKey();
        this.keyStore = other.getKeyStore();
        this.pubSecKeys = other.getPubSecKeys();
        this.secrets = other.getSecrets();
        this.audience = other.getAudience();
        this.issuer = other.getIssuer();
        this.ignoreExpiration = other.isIgnoreExpiration();
        this.leeway = other.getLeeway();
    }

    private void init() {
        this.permissionsClaimKey = PERMISSIONS_CLAIM_KEY;
        this.ignoreExpiration = false;
        this.leeway = 0;
    }

    public JWTAuthOptions(JsonObject json) {
        this.init();
        JWTAuthOptionsConverter.fromJson(json, this);
    }

    public String getPermissionsClaimKey() {
        return this.permissionsClaimKey;
    }

    public JWTAuthOptions setPermissionsClaimKey(String permissionsClaimKey) {
        this.permissionsClaimKey = permissionsClaimKey;
        return this;
    }

    public KeyStoreOptions getKeyStore() {
        return this.keyStore;
    }

    public JWTAuthOptions setKeyStore(KeyStoreOptions keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public JWTAuthOptions setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public List<SecretOptions> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<SecretOptions> secrets) {
        this.secrets = secrets;
    }

    public JWTAuthOptions addSecret(SecretOptions secret) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretOptions>();
        }
        this.secrets.add(secret);
        return this;
    }

    public JWTAuthOptions addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public JWTAuthOptions setAudience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public JWTAuthOptions addAudience(String audience) {
        if (this.audience == null) {
            this.audience = new ArrayList<String>();
        }
        this.audience.add(audience);
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JWTAuthOptions setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public boolean isIgnoreExpiration() {
        return this.ignoreExpiration;
    }

    public JWTAuthOptions setIgnoreExpiration(boolean ignoreExpiration) {
        this.ignoreExpiration = ignoreExpiration;
        return this;
    }

    public int getLeeway() {
        return this.leeway;
    }

    public JWTAuthOptions setLeeway(int leeway) {
        this.leeway = leeway;
        return this;
    }
}

