/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import java.util.ArrayList;

public class JWTAuthOptionsConverter {
    public static void fromJson(JsonObject json, JWTAuthOptions obj) {
        if (json.getValue("audience") instanceof JsonArray) {
            ArrayList<String> list = new ArrayList<String>();
            json.getJsonArray("audience").forEach(item -> {
                if (item instanceof String) {
                    list.add((String)item);
                }
            });
            obj.setAudience(list);
        }
        if (json.getValue("audiences") instanceof JsonArray) {
            json.getJsonArray("audiences").forEach(item -> {
                if (item instanceof String) {
                    obj.addAudience((String)item);
                }
            });
        }
        if (json.getValue("ignoreExpiration") instanceof Boolean) {
            obj.setIgnoreExpiration((Boolean)json.getValue("ignoreExpiration"));
        }
        if (json.getValue("issuer") instanceof String) {
            obj.setIssuer((String)json.getValue("issuer"));
        }
        if (json.getValue("keyStore") instanceof JsonObject) {
            obj.setKeyStore(new KeyStoreOptions((JsonObject)json.getValue("keyStore")));
        }
        if (json.getValue("permissionsClaimKey") instanceof String) {
            obj.setPermissionsClaimKey((String)json.getValue("permissionsClaimKey"));
        }
        if (json.getValue("pubSecKeys") instanceof JsonArray) {
            json.getJsonArray("pubSecKeys").forEach(item -> {
                if (item instanceof JsonObject) {
                    obj.addPubSecKey(new PubSecKeyOptions((JsonObject)item));
                }
            });
        }
        if (json.getValue("secrets") instanceof JsonArray) {
            json.getJsonArray("secrets").forEach(item -> {
                if (item instanceof JsonObject) {
                    obj.addSecret(new SecretOptions((JsonObject)item));
                }
            });
        }
    }

    public static void toJson(JWTAuthOptions obj, JsonObject json) {
        if (obj.getAudience() != null) {
            JsonArray array = new JsonArray();
            obj.getAudience().forEach(item -> array.add(item));
            json.put("audience", array);
        }
        json.put("ignoreExpiration", Boolean.valueOf(obj.isIgnoreExpiration()));
        if (obj.getIssuer() != null) {
            json.put("issuer", obj.getIssuer());
        }
        if (obj.getPermissionsClaimKey() != null) {
            json.put("permissionsClaimKey", obj.getPermissionsClaimKey());
        }
    }
}

