/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.jwt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;

@DataObject
public class JWTOptions {
    private final JsonObject json;

    public JWTOptions() {
        this.json = new JsonObject();
    }

    public JWTOptions(JsonObject json) {
        this.json = json.copy();
    }

    public JWTOptions(JWTOptions options) {
        this(options.toJSON());
    }

    public String getAlgorithm() {
        return this.json.getString("algorithm", "HS256");
    }

    public JWTOptions setAlgorithm(String algorithm) {
        this.json.put("algorithm", algorithm);
        return this;
    }

    public Long getExpiresInMinutes() {
        return this.json.getLong("expiresInMinutes");
    }

    public JWTOptions setExpiresInMinutes(long expiresInMinutes) {
        this.json.put("expiresInMinutes", Long.valueOf(expiresInMinutes));
        return this;
    }

    public Long getExpiresInSeconds() {
        return this.json.getLong("expiresInSeconds");
    }

    public JWTOptions setExpiresInSeconds(long expiresInSeconds) {
        this.json.put("expiresInSeconds", Long.valueOf(expiresInSeconds));
        return this;
    }

    public JsonArray getAudience() {
        return this.json.getJsonArray("audience");
    }

    public JWTOptions setAudience(List<String> audience) {
        this.json.put("audience", new JsonArray(audience));
        return this;
    }

    public JWTOptions addAudience(String audience) {
        if (!this.json.containsKey("audience")) {
            this.json.put("audience", new JsonArray());
        }
        this.json.getJsonArray("audience").add(audience);
        return this;
    }

    public String getSubject() {
        return this.json.getString("subject");
    }

    public JWTOptions setSubject(String subject) {
        this.json.put("subject", subject);
        return this;
    }

    public String getIssuer() {
        return this.json.getString("issuer");
    }

    public JWTOptions setIssuer(String issuer) {
        this.json.put("issuer", issuer);
        return this;
    }

    public boolean getNoTimestamp() {
        return this.json.getBoolean("noTimestamp");
    }

    public JWTOptions setNoTimestamp(boolean noTimestamp) {
        this.json.put("noTimestamp", Boolean.valueOf(noTimestamp));
        return this;
    }

    public JsonObject getHeader() {
        return this.json.getJsonObject("header");
    }

    public JWTOptions addHeader(String name, String value) {
        if (!this.json.containsKey("header")) {
            this.json.put("header", new JsonObject());
        }
        this.getHeader().put(name, value);
        return this;
    }

    public JWTOptions setPermissions(List<String> permissions) {
        this.json.put("permissions", new JsonArray(permissions));
        return this;
    }

    public JWTOptions addPermission(String permission) {
        if (!this.json.containsKey("permissions")) {
            this.json.put("permissions", new JsonArray());
        }
        this.json.getJsonArray("permissions").add(permission);
        return this;
    }

    public JsonObject toJSON() {
        return this.json;
    }
}

