/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.hashing.HashingAlgorithm;
import io.vertx.ext.auth.hashing.HashingStrategy;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions;
import io.vertx.ext.auth.htpasswd.impl.hash.Plaintext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtpasswdAuthImpl
implements HtpasswdAuth {
    private final HashingStrategy strategy = HashingStrategy.load();
    private final Map<String, String> htUsers = new HashMap<String, String>();

    public HtpasswdAuthImpl(Vertx vertx, HtpasswdAuthOptions options) {
        for (String line : vertx.fileSystem().readFileBlocking(options.getHtpasswdFile()).toString().split("\\r?\\n")) {
            Pattern entry;
            Matcher m;
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(m = (entry = Pattern.compile("^([^:]+):(.+)")).matcher(line)).matches()) continue;
            this.htUsers.put(m.group(1), m.group(2));
        }
        if (options.isPlainTextEnabled()) {
            this.strategy.put("", (HashingAlgorithm)new Plaintext());
        }
    }

    public Future<User> authenticate(Credentials credential) {
        UsernamePasswordCredentials authInfo;
        try {
            try {
                authInfo = (UsernamePasswordCredentials)credential;
            }
            catch (ClassCastException e) {
                throw new CredentialValidationException("Invalid credentials type", (Throwable)e);
            }
            authInfo.checkValid(null);
        }
        catch (RuntimeException e) {
            return Future.failedFuture((Throwable)e);
        }
        if (!this.htUsers.containsKey(authInfo.getUsername())) {
            return Future.failedFuture((String)"Unknown username.");
        }
        if (this.strategy.verify(this.htUsers.get(authInfo.getUsername()), authInfo.getPassword())) {
            User user = User.fromName((String)authInfo.getUsername());
            user.principal().put("amr", Collections.singletonList("pwd"));
            return Future.succeededFuture((Object)user);
        }
        return Future.failedFuture((String)"Bad response");
    }
}

