/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.HashingAlgorithm;
import io.vertx.ext.auth.HashingStrategy;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuthOptions;
import io.vertx.ext.auth.htpasswd.impl.hash.Plaintext;
import io.vertx.ext.auth.impl.UserImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HtpasswdAuthImpl
implements HtpasswdAuth {
    private final HashingStrategy strategy = HashingStrategy.load();
    private final Map<String, String> htUsers = new HashMap<String, String>();

    public HtpasswdAuthImpl(Vertx vertx, HtpasswdAuthOptions options) {
        for (String line : vertx.fileSystem().readFileBlocking(options.getHtpasswdFile()).toString().split("\\r?\\n")) {
            Pattern entry;
            Matcher m;
            if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(m = (entry = Pattern.compile("^([^:]+):(.+)")).matcher(line)).matches()) continue;
            this.htUsers.put(m.group(1), m.group(2));
        }
        if (options.isPlainTextEnabled()) {
            this.strategy.put("", (HashingAlgorithm)new Plaintext());
        }
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        this.authenticate((Credentials)new UsernamePasswordCredentials(authInfo), resultHandler);
    }

    public void authenticate(Credentials credential, Handler<AsyncResult<User>> resultHandler) {
        try {
            UsernamePasswordCredentials authInfo = (UsernamePasswordCredentials)credential;
            authInfo.checkValid(null);
            if (!this.htUsers.containsKey(authInfo.getUsername())) {
                resultHandler.handle((Object)Future.failedFuture((String)"Unknown username."));
                return;
            }
            if (this.strategy.verify(this.htUsers.get(authInfo.getUsername()), authInfo.getPassword())) {
                resultHandler.handle((Object)Future.succeededFuture((Object)new UserImpl(new JsonObject().put("username", (Object)authInfo.getUsername()))));
            } else {
                resultHandler.handle((Object)Future.failedFuture((String)"Bad response"));
            }
        }
        catch (RuntimeException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

