/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.htpasswd;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthOptions;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.htpasswd.HtpasswdAuth;
import io.vertx.ext.auth.htpasswd.HtpasswdAuthOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class HtpasswdAuthOptions
implements AuthOptions {
    private String htpasswdFile = ".htpasswd";
    private boolean plainTextEnabled = false;

    public HtpasswdAuthOptions() {
    }

    public HtpasswdAuthOptions(JsonObject json) {
        this();
        HtpasswdAuthOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public HtpasswdAuthOptions(HtpasswdAuthOptions that) {
        this();
        this.htpasswdFile = that.htpasswdFile;
        this.plainTextEnabled = that.plainTextEnabled;
    }

    public HtpasswdAuthOptions setPlainTextEnabled(boolean plainTextEnabled) {
        this.plainTextEnabled = plainTextEnabled;
        return this;
    }

    public boolean isPlainTextEnabled() {
        return this.plainTextEnabled;
    }

    public String getHtpasswdFile() {
        return this.htpasswdFile;
    }

    public HtpasswdAuthOptions setHtpasswdFile(String htpasswdFile) {
        this.htpasswdFile = htpasswdFile;
        return this;
    }

    public AuthOptions clone() {
        return new HtpasswdAuthOptions(this);
    }

    public AuthProvider createProvider(Vertx vertx) {
        return HtpasswdAuth.create(vertx, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        HtpasswdAuthOptionsConverter.toJson(this, json);
        return json;
    }
}

