/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.ext.auth.hashing.HashString;
import io.vertx.ext.auth.hashing.HashingAlgorithm;
import io.vertx.ext.auth.hashing.HashingStrategy;
import java.util.HashMap;
import java.util.Map;

public class HashingStrategyImpl
implements HashingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(HashingStrategyImpl.class);
    private final Map<String, HashingAlgorithm> algorithms = new HashMap<String, HashingAlgorithm>();

    public void add(HashingAlgorithm algorithm) {
        this.algorithms.put(algorithm.id(), algorithm);
    }

    @Override
    public String hash(String id, Map<String, String> params, String salt, String password) {
        HashingAlgorithm algorithm = this.algorithms.get(id);
        if (algorithm == null) {
            throw new RuntimeException(id + " algorithm is not available.");
        }
        HashString hashString = new HashString(id, params, salt);
        String hash = algorithm.hash(hashString, password);
        return HashString.encode(algorithm, hashString.params(), hashString.salt(), hash);
    }

    @Override
    public boolean verify(String hash, String password) {
        if (hash == null || password == null) {
            return false;
        }
        HashString hashString = new HashString(hash);
        HashingAlgorithm algorithm = this.algorithms.get(hashString.id());
        if (algorithm == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No hash strategy for algorithm: " + hashString.id()));
            }
            return false;
        }
        if (hashString.hash() == null) {
            return false;
        }
        String hasha = hashString.hash();
        String hashb = algorithm.hash(hashString, password);
        int diff = hasha.length() ^ hashb.length();
        for (int i = 0; i < hasha.length() && i < hashb.length(); ++i) {
            diff |= hasha.charAt(i) ^ hashb.charAt(i);
        }
        return diff == 0;
    }

    @Override
    public HashingAlgorithm get(String id) {
        return this.algorithms.get(id);
    }

    @Override
    public HashingStrategy put(String id, HashingAlgorithm algorithm) {
        if (this.algorithms.containsKey(id)) {
            LOG.warn((Object)("Existing algorithm: " + id + " will be replaced!"));
        }
        this.algorithms.put(id, algorithm);
        return this;
    }
}

