/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public final class JWS {
    public static final String ES256 = "ES256";
    public static final String ES384 = "ES384";
    public static final String ES512 = "ES512";
    public static final String PS256 = "PS256";
    public static final String PS384 = "PS384";
    public static final String PS512 = "PS512";
    public static final String ES256K = "ES256K";
    public static final String RS256 = "RS256";
    public static final String RS384 = "RS384";
    public static final String RS512 = "RS512";
    public static final String RS1 = "RS1";
    private static final CertificateFactory X509;

    public static Signature getSignature(String alg) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        switch (alg) {
            case "ES256": 
            case "ES256K": {
                return Signature.getInstance("SHA256withECDSA");
            }
            case "ES384": {
                return Signature.getInstance("SHA384withECDSA");
            }
            case "ES512": {
                return Signature.getInstance("SHA512withECDSA");
            }
            case "RS256": {
                return Signature.getInstance("SHA256withRSA");
            }
            case "RS384": {
                return Signature.getInstance("SHA384withRSA");
            }
            case "RS512": {
                return Signature.getInstance("SHA512withRSA");
            }
            case "RS1": {
                return Signature.getInstance("SHA1withRSA");
            }
            case "PS256": {
                Signature sig = Signature.getInstance("RSASSA-PSS");
                sig.setParameter(new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1));
                return sig;
            }
            case "PS384": {
                Signature sig = Signature.getInstance("RSASSA-PSS");
                sig.setParameter(new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1));
                return sig;
            }
            case "PS512": {
                Signature sig = Signature.getInstance("RSASSA-PSS");
                sig.setParameter(new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1));
                return sig;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static boolean verifySignature(String alg, X509Certificate certificate, byte[] signature, byte[] data) throws InvalidKeyException, SignatureException, InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        if (alg == null || certificate == null || signature == null || data == null) {
            throw new SignatureException("Cannot validate signature, one of {alg, certificate, signature, data} is null");
        }
        switch (alg) {
            case "ES256": 
            case "ES384": 
            case "ES512": 
            case "ES256K": {
                if (JWS.isASN1(signature)) break;
                signature = JWS.toASN1(signature);
            }
        }
        Signature sig = JWS.getSignature(alg);
        sig.initVerify(certificate);
        sig.update(data);
        return sig.verify(signature);
    }

    public static int getSignatureLength(String alg, PublicKey publicKey) throws NoSuchAlgorithmException {
        if (publicKey instanceof RSAKey) {
            return ((RSAKey)((Object)publicKey)).getModulus().bitLength() + 7 >> 3;
        }
        switch (alg) {
            case "ES256": 
            case "ES256K": {
                return 64;
            }
            case "ES384": {
                return 96;
            }
            case "ES512": {
                return 132;
            }
            case "RS1": 
            case "RS256": 
            case "PS256": {
                return 256;
            }
            case "RS384": 
            case "PS384": {
                return 384;
            }
            case "RS512": 
            case "PS512": {
                return 512;
            }
        }
        throw new NoSuchAlgorithmException();
    }

    public static X509Certificate parseX5c(String data) throws CertificateException {
        return (X509Certificate)X509.generateCertificate(new ByteArrayInputStream(JWS.addBoundaries(data, "CERTIFICATE").getBytes(StandardCharsets.UTF_8)));
    }

    public static X509Certificate parseX5c(byte[] data) throws CertificateException {
        return (X509Certificate)X509.generateCertificate(new ByteArrayInputStream(data));
    }

    public static X509CRL parseX5crl(String data) throws CRLException {
        return (X509CRL)X509.generateCRL(new ByteArrayInputStream(JWS.addBoundaries(data, "X509 CRL").getBytes(StandardCharsets.UTF_8)));
    }

    public static X509CRL parseX5crl(byte[] data) throws CRLException {
        return (X509CRL)X509.generateCRL(new ByteArrayInputStream(data));
    }

    private static boolean byteAtIndexIs(byte[] data, int idx, int expected) {
        if (data == null) {
            return false;
        }
        if (data.length <= idx) {
            return false;
        }
        return Byte.toUnsignedInt(data[idx]) == expected;
    }

    private static boolean byteAtIndexLte(byte[] data, int idx, int expected) {
        if (data == null) {
            return false;
        }
        if (data.length <= idx) {
            return false;
        }
        if (data[idx] <= 0) {
            return false;
        }
        return Byte.toUnsignedInt(data[idx]) <= expected;
    }

    public static boolean isASN1(byte[] sig) {
        int offset;
        if (!JWS.byteAtIndexIs(sig, 0, 48)) {
            return false;
        }
        if (sig.length < 128) {
            offset = 0;
        } else {
            if (!JWS.byteAtIndexIs(sig, 1, 129)) {
                return false;
            }
            offset = 1;
        }
        if (!JWS.byteAtIndexIs(sig, offset + 1, sig.length - offset - 2)) {
            return false;
        }
        offset += 2;
        for (int i = 0; i < 2; ++i) {
            if (!JWS.byteAtIndexIs(sig, offset, 2)) {
                return false;
            }
            if (!JWS.byteAtIndexLte(sig, offset + 1, sig.length - offset - 2)) {
                return false;
            }
            offset = offset + sig[offset + 1] + 2;
        }
        return offset == sig.length;
    }

    public static byte[] toJWS(byte[] derSignature, int signatureLength) {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, signatureLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public static byte[] toASN1(byte[] jwsSignature) {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new RuntimeException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }

    private static String addBoundaries(String certificate, String boundary) {
        String CERT_BOUNDARY_BEGIN = "-----BEGIN " + boundary + "-----\n";
        String CERT_BOUNDARY_END = "\n-----END " + boundary + "-----\n";
        if (certificate.contains(CERT_BOUNDARY_BEGIN) && certificate.contains(CERT_BOUNDARY_END)) {
            return certificate;
        }
        return CERT_BOUNDARY_BEGIN + certificate + CERT_BOUNDARY_END;
    }

    static {
        try {
            X509 = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

