/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

import io.vertx.ext.auth.impl.jose.JWK;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class JWE {
    public static byte[] encrypt(JWK key, byte[] payload) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key.isFor(2)) {
            PublicKey publicKey = key.getPublicKey();
            if (publicKey == null) {
                throw new IllegalStateException("Key doesn't contain a pubKey material");
            }
            Cipher cipher = Cipher.getInstance(key.getType());
            cipher.init(1, publicKey);
            cipher.update(payload);
            return cipher.doFinal();
        }
        throw new IllegalStateException("Key use is not 'enc'");
    }

    public static byte[] decrypt(JWK key, byte[] payload) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        if (key.isFor(2)) {
            PrivateKey privateKey = key.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("Key doesn't contain a privKey material");
            }
            Cipher cipher = Cipher.getInstance(key.getType());
            cipher.init(2, privateKey);
            cipher.update(payload);
            return cipher.doFinal();
        }
        throw new IllegalStateException("Key use is not 'enc'");
    }
}

