/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl.jose;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.NoSuchKeyIdException;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.jose.Crypto;
import io.vertx.ext.auth.impl.jose.CryptoNone;
import io.vertx.ext.auth.impl.jose.JWK;
import io.vertx.ext.auth.impl.jose.JWS;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JWT {
    private final Logger logger = LoggerFactory.getLogger(JWT.class);
    private static final Random RND = new Random();
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Base64.Encoder urlEncoder = Base64.getUrlEncoder().withoutPadding();
    private static final Base64.Decoder urlDecoder = Base64.getUrlDecoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private boolean allowEmbeddedKey = false;
    private MessageDigest nonceDigest;
    private final Map<String, List<Crypto>> SIGN = new ConcurrentHashMap<String, List<Crypto>>();
    private final Map<String, List<Crypto>> VERIFY = new ConcurrentHashMap<String, List<Crypto>>();

    public JWT() {
        this.SIGN.put("none", Collections.singletonList(new CryptoNone()));
        this.VERIFY.put("none", Collections.singletonList(new CryptoNone()));
    }

    public JWT addJWK(JWK jwk) {
        List current = null;
        if (jwk.isFor(2)) {
            current = this.VERIFY.computeIfAbsent(jwk.getAlgorithm(), k -> new ArrayList());
            this.addJWK(current, jwk);
        }
        if (jwk.isFor(1)) {
            current = this.SIGN.computeIfAbsent(jwk.getAlgorithm(), k -> new ArrayList());
            this.addJWK(current, jwk);
        }
        if (current == null) {
            throw new IllegalStateException("unknown JWK use: " + jwk.getUse());
        }
        return this;
    }

    public JWT allowEmbeddedKey(boolean allowEmbeddedKey) {
        this.allowEmbeddedKey = allowEmbeddedKey;
        return this;
    }

    public JWT nonceAlgorithm(String alg) {
        if (alg == null) {
            this.nonceDigest = null;
        } else {
            try {
                this.nonceDigest = MessageDigest.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this;
    }

    private void addJWK(List<Crypto> current, JWK jwk) {
        boolean replaced = false;
        for (int i = 0; i < current.size(); ++i) {
            if (!current.get(i).getLabel().equals(jwk.getLabel())) continue;
            current.set(i, jwk);
            replaced = true;
            break;
        }
        if (!replaced) {
            current.add(jwk);
        }
    }

    public static JsonObject parse(byte[] token) {
        return JWT.parse(new String(token, UTF8));
    }

    public static JsonObject parse(String token) {
        String[] segments = token.split("\\.");
        if (segments.length < 2 || segments.length > 3) {
            throw new RuntimeException("Not enough or too many segments [" + segments.length + "]");
        }
        String headerSeg = segments[0];
        String payloadSeg = segments[1];
        String signatureSeg = segments.length == 2 ? null : segments[2];
        JsonObject header = new JsonObject(new String(JWT.base64urlDecode(headerSeg), UTF8));
        JsonObject payload = new JsonObject(new String(JWT.base64urlDecode(payloadSeg), UTF8));
        return new JsonObject().put("header", (Object)header).put("payload", (Object)payload).put("signatureBase", (Object)(headerSeg + "." + payloadSeg)).put("signature", (Object)signatureSeg);
    }

    public JsonObject decode(String token) {
        return this.decode(token, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject decode(String token, boolean full) {
        String signatureSeg;
        String[] segments = token.split("\\.");
        if (segments.length < 2) {
            throw new IllegalStateException("Invalid format for JWT");
        }
        String headerSeg = segments[0];
        String payloadSeg = segments[1];
        String string = signatureSeg = segments.length == 3 ? segments[2] : null;
        if ("".equals(signatureSeg)) {
            throw new IllegalStateException("Signature is required");
        }
        JsonObject header = new JsonObject(Buffer.buffer((byte[])JWT.base64urlDecode(headerSeg)));
        boolean unsecure = this.isUnsecure();
        if (unsecure) {
            if (!this.allowEmbeddedKey && segments.length != 2) {
                throw new IllegalStateException("JWT is in unsecured mode but token is signed.");
            }
        } else if (!this.allowEmbeddedKey && segments.length != 3) {
            throw new IllegalStateException("JWT is in secure mode but token is not signed.");
        }
        JsonObject payload = new JsonObject(Buffer.buffer((byte[])JWT.base64urlDecode(payloadSeg)));
        String alg = header.getString("alg");
        if (!unsecure && "none".equals(alg)) {
            throw new IllegalStateException("Algorithm \"none\" not allowed");
        }
        if (this.allowEmbeddedKey && header.containsKey("x5c")) {
            if (signatureSeg == null) {
                throw new IllegalStateException("missing signature segment");
            }
            try {
                JsonArray chain = header.getJsonArray("x5c");
                ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
                if (chain == null || chain.size() == 0) {
                    throw new IllegalStateException("x5c chain is null or empty");
                }
                for (int i = 0; i < chain.size(); ++i) {
                    certChain.add(JWS.parseX5c(decoder.decode(chain.getString(i).getBytes(UTF8))));
                }
                CertificateHelper.checkValidity(certChain, false, null);
                if (JWS.verifySignature(alg, (X509Certificate)certChain.get(0), JWT.base64urlDecode(signatureSeg), (headerSeg + "." + payloadSeg).getBytes(UTF8))) {
                    return full ? new JsonObject().put("header", (Object)header).put("payload", (Object)payload) : payload;
                }
                throw new RuntimeException("Signature verification failed");
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                throw new RuntimeException("Signature verification failed", e);
            }
        }
        List<Crypto> cryptos = this.VERIFY.get(alg);
        if (cryptos == null || cryptos.size() == 0) {
            throw new NoSuchKeyIdException(alg);
        }
        if (!unsecure) {
            if (signatureSeg == null) {
                throw new IllegalStateException("missing signature segment");
            }
            byte[] payloadInput = JWT.base64urlDecode(signatureSeg);
            if (this.nonceDigest != null && header.containsKey("nonce")) {
                JWT i = this;
                synchronized (i) {
                    this.nonceDigest.reset();
                    header.put("nonce", (Object)this.nonceDigest.digest(header.getString("nonce").getBytes(StandardCharsets.UTF_8)));
                    headerSeg = urlEncoder.encodeToString(header.encode().getBytes(StandardCharsets.UTF_8));
                }
            }
            byte[] signingInput = (headerSeg + "." + payloadSeg).getBytes(UTF8);
            String kid = header.getString("kid");
            boolean hasKey = false;
            for (Crypto c : cryptos) {
                if (kid != null && c.getId() != null && !kid.equals(c.getId())) continue;
                hasKey = true;
                if (!c.verify(payloadInput, signingInput)) continue;
                return full ? new JsonObject().put("header", (Object)header).put("payload", (Object)payload) : payload;
            }
            if (hasKey) {
                throw new RuntimeException("Signature verification failed");
            }
            throw new NoSuchKeyIdException(alg, kid);
        }
        return full ? new JsonObject().put("header", (Object)header).put("payload", (Object)payload) : payload;
    }

    public boolean isScopeGranted(JsonObject jwt, JWTOptions options) {
        if (jwt == null) {
            return false;
        }
        if (options.getScopes() == null || options.getScopes().isEmpty()) {
            return true;
        }
        if (jwt.getValue("scope") == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Invalid JWT: scope claim is required");
            }
            return false;
        }
        JsonArray target = jwt.getValue("scope") instanceof String ? new JsonArray(Stream.of(jwt.getString("scope").split(options.getScopeDelimiter())).collect(Collectors.toList())) : jwt.getJsonArray("scope");
        if (!target.getList().containsAll(options.getScopes())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)String.format("Invalid JWT scopes expected[%s] actual[%s]", options.getScopes(), target.getList()));
            }
            return false;
        }
        return true;
    }

    public String sign(JsonObject payload, JWTOptions options) {
        String algorithm = options.getAlgorithm();
        List<Crypto> cryptos = this.SIGN.get(algorithm);
        if (cryptos == null || cryptos.size() == 0) {
            throw new RuntimeException("Algorithm not supported: " + algorithm);
        }
        Crypto crypto = cryptos.get(RND.nextInt(cryptos.size()));
        JsonObject header = new JsonObject().mergeIn(options.getHeader()).put("typ", (Object)"JWT").put("alg", (Object)algorithm);
        if (crypto.getId() != null) {
            header.put("kid", (Object)crypto.getId());
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        if (!options.isNoTimestamp()) {
            payload.put("iat", payload.getValue("iat", (Object)timestamp));
        }
        if (options.getExpiresInSeconds() > 0) {
            payload.put("exp", (Object)(timestamp + (long)options.getExpiresInSeconds()));
        }
        if (options.getAudience() != null && options.getAudience().size() >= 1) {
            if (options.getAudience().size() > 1) {
                payload.put("aud", (Object)new JsonArray(options.getAudience()));
            } else {
                payload.put("aud", (Object)options.getAudience().get(0));
            }
        }
        if (options.getScopes() != null && options.getScopes().size() >= 1) {
            if (options.hasScopeDelimiter()) {
                payload.put("scope", (Object)String.join((CharSequence)options.getScopeDelimiter(), options.getScopes()));
            } else {
                payload.put("scope", (Object)new JsonArray(options.getScopes()));
            }
        }
        if (options.getIssuer() != null) {
            payload.put("iss", (Object)options.getIssuer());
        }
        if (options.getSubject() != null) {
            payload.put("sub", (Object)options.getSubject());
        }
        String headerSegment = JWT.base64urlEncode(header.encode());
        String payloadSegment = JWT.base64urlEncode(payload.encode());
        String signingInput = headerSegment + "." + payloadSegment;
        String signSegment = JWT.base64urlEncode(crypto.sign(signingInput.getBytes(UTF8)));
        return headerSegment + "." + payloadSegment + "." + signSegment;
    }

    private static byte[] base64urlDecode(String str) {
        return urlDecoder.decode(str.getBytes(UTF8));
    }

    private static String base64urlEncode(String str) {
        return JWT.base64urlEncode(str.getBytes(UTF8));
    }

    private static String base64urlEncode(byte[] bytes) {
        return urlEncoder.encodeToString(bytes);
    }

    public boolean isUnsecure() {
        return this.VERIFY.size() == 1 && this.SIGN.size() == 1;
    }

    public Collection<String> availableAlgorithms() {
        HashSet<String> algorithms = new HashSet<String>();
        algorithms.addAll(this.VERIFY.keySet());
        algorithms.addAll(this.SIGN.keySet());
        return algorithms;
    }
}

