/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;

@VertxGen(concrete=false)
public interface Credentials {
    default public <V> void checkValid(V arg) throws CredentialValidationException {
    }

    public JsonObject toJson();

    @Fluent
    default public Credentials applyHttpChallenge(String challenge, HttpMethod method, String uri, Integer nc, String cnonce) throws CredentialValidationException {
        if (challenge != null) {
            throw new CredentialValidationException("This implementation can't handle HTTP Authentication");
        }
        return this;
    }

    default public Credentials applyHttpChallenge(String challenge, HttpMethod method, String uri) throws CredentialValidationException {
        return this.applyHttpChallenge(challenge, method, uri, null, null);
    }

    default public Credentials applyHttpChallenge(String challenge) throws CredentialValidationException {
        return this.applyHttpChallenge(challenge, null, null, null, null);
    }

    default public String toHttpAuthorization() {
        throw new UnsupportedOperationException(this.getClass().getName() + " cannot be converted to a HTTP Authorization");
    }
}

