/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authentication;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.CredentialValidationException;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentialsConverter;
import java.util.Map;

@DataObject(generateConverter=true, publicConverter=false)
public class UsernamePasswordCredentials
implements Credentials {
    private String password;
    private String username;

    protected UsernamePasswordCredentials() {
    }

    public UsernamePasswordCredentials(String username, String password) {
        this.setUsername(username);
        this.setPassword(password);
    }

    public UsernamePasswordCredentials(JsonObject jsonObject) {
        UsernamePasswordCredentialsConverter.fromJson((Iterable<Map.Entry<String, Object>>)jsonObject, this);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public UsernamePasswordCredentials setPassword(String password) {
        this.password = password;
        return this;
    }

    public UsernamePasswordCredentials setUsername(String username) {
        this.username = username;
        return this;
    }

    @Override
    public <V> void checkValid(V arg) throws CredentialValidationException {
        if (this.username == null || this.username.length() == 0) {
            throw new CredentialValidationException("username cannot be null or empty");
        }
        if (this.password == null) {
            throw new CredentialValidationException("password cannot be null");
        }
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        UsernamePasswordCredentialsConverter.toJson(this, result);
        return result;
    }

    public String toString() {
        return this.toJson().encode();
    }
}

