/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;

public final class CertificateHelper {
    private CertificateHelper() {
    }

    public static void checkValidity(List<X509Certificate> certificates) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException {
        for (int i = 0; i < certificates.size(); ++i) {
            X509Certificate subjectCert = certificates.get(i);
            subjectCert.checkValidity();
            if (certificates.size() == 1) {
                return;
            }
            X509Certificate issuerCert = i + 1 >= certificates.size() ? subjectCert : certificates.get(i + 1);
            if (!subjectCert.getIssuerX500Principal().equals(issuerCert.getSubjectX500Principal())) {
                throw new CertificateException("Failed to validate certificate path! Issuers dont match!");
            }
            subjectCert.verify(issuerCert.getPublicKey());
        }
    }
}

