/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\rUx!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u0003y\u0012a\u00017pOV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005)1\u000f\u001c45U*\tQ%A\u0002pe\u001eL!a\n\u0012\u0003\r1{wmZ3s\u0011\u0019I\u0013\u0003)A\u0005A\u0005!An\\4!\u0011\u001dY\u0013C1A\u0005\u00021\nqaQ8v]R,'/F\u0001.!\tqs'D\u00010\u0015\t\u0001\u0014'\u0001\u0004bi>l\u0017n\u0019\u0006\u0003eM\n!bY8oGV\u0014(/\u001a8u\u0015\t!T'\u0001\u0003vi&d'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003q=\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019Q\u0014\u0003)A\u0005[\u0005A1i\\;oi\u0016\u0014\b\u0005C\u0004=#\t\u0007I\u0011A\u001f\u0002!M+'O^3s-\u0016\u00148/[8o\u0017\u0016LX#\u0001 \u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005+\u0014\u0001\u00027b]\u001eL!a\u0011!\u0003\rM#(/\u001b8h\u0011\u0019)\u0015\u0003)A\u0005}\u0005\t2+\u001a:wKJ4VM]:j_:\\U-\u001f\u0011\t\u000f\u001d\u000b\u0012\u0013!C\u0001\u0011\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012!\u0013\u0016\u0003\u0015:\u0003\"a\u0013'\u000e\u0003\u0011I!!\u0014\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003%)hn\u00195fG.,GM\u0003\u0002U-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u000b&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0001,EI\u0001\n\u0003I\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001[U\tYf\n\u0005\u0002]?6\tQL\u0003\u0002_\t\u000511m\u001c7v[:L!\u0001Y/\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9!-EI\u0001\n\u0003\u0019\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001eU\t)g\n\u0005\u0002]M&\u0011q-\u0018\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001dI\u0017#%A\u0005\u0002)\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#A6+\u00051t\u0005CA7u\u001b\u0005q'BA8q\u0003\u001d\u0019\u0007.\u00198oK2T!!\u001d:\u0002\u000b9,G\u000f^=\u000b\u0003M\f!![8\n\u0005Ut'AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\boF\t\n\u0011\"\u0001y\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\t\u0011P\u000b\u0002{\u001dB\u001110`\u0007\u0002y*\u0011!GF\u0005\u0003}r\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0007\u000bI\u0011\u0001!!\u0001\u0014\r}$\u00121AA\b!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005\u0005\u0005)1m\u001c3fG&!\u0011QBA\u0004\u0005q\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\u0012+G.Z4bi\u0016\u00042aSA\t\u0013\r\t\u0019\u0002\u0002\u0002\u000b\u0007>tg.Z2uS>t\u0007\"CA\f\u007f\n\u0005\t\u0015!\u0003K\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]\"I\u00111D@\u0003\u0002\u0003\u0006IaW\u0001\u0010K:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"I\u0011qD@\u0003\u0002\u0003\u0006I!Z\u0001\u0010I\u0016\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"I\u00111E@\u0003\u0002\u0003\u0006I\u0001\\\u0001\u0006OJ|W\u000f\u001d\u0005\n\u0003Oy(\u0011!Q\u0001\ni\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\rmyH\u0011AA\u0016)1\ti#a\f\u00022\u0005M\u0012QGA\u001c!\t\u0001r\u0010C\u0005\u0002\u0018\u0005%\u0002\u0013!a\u0001\u0015\"I\u00111DA\u0015!\u0003\u0005\ra\u0017\u0005\n\u0003?\tI\u0003%AA\u0002\u0015D\u0011\"a\t\u0002*A\u0005\t\u0019\u00017\t\u0013\u0005\u001d\u0012\u0011\u0006I\u0001\u0002\u0004Q\b\"CA\u001e\u007f\n\u0007IQBA\u001f\u0003E\u0019wN\u001c8fGRLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003\u007f\u0001B!!\u0002\u0002B%!\u00111IA\u0004\u0005m\u0001vn\u001d;he\u0016\u001c\u0016\u000bT\"p]:,7\r^5p]\"\u000bg\u000e\u001a7fe\"A\u0011qI@!\u0002\u001b\ty$\u0001\nd_:tWm\u0019;j_:D\u0015M\u001c3mKJ\u0004\u0003\"CA&\u007f\n\u0007IQBA'\u00031\u0019WO\u001d:f]R\u001cu.\u001e8u+\t\ty\u0005E\u0002\u0016\u0003#J1!a\u0015\u0017\u0005\u0011auN\\4\t\u0011\u0005]s\u0010)A\u0007\u0003\u001f\nQbY;se\u0016tGoQ8v]R\u0004\u0003\"CA.\u007f\n\u0007IQBA/\u0003e\u0001(/\u001a9be\u0016$7\u000b^1uK6,g\u000e^:D_VtG/\u001a:\u0016\u0005\u0005}\u0003c\u0001\u0018\u0002b%\u0019\u00111M\u0018\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t9g Q\u0001\u000e\u0005}\u0013A\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ\u0004\u0003\"CA6\u007f\n\u0007IqBA7\u0003aIg\u000e^3s]\u0006dW\t_3dkRLwN\\\"p]R,\u0007\u0010^\u000b\u0002u\"9\u0011\u0011O@!\u0002\u001bQ\u0018!G5oi\u0016\u0014h.\u00197Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0002B\u0011\"!\u001e\u0000\u0001\u0004%I!a\u001e\u0002\u001bI,\u0017\rZ=G_J\fV/\u001a:z+\t\tI\bE\u0002\u0016\u0003wJ1!! \u0017\u0005\u001d\u0011un\u001c7fC:D\u0011\"!!\u0000\u0001\u0004%I!a!\u0002#I,\u0017\rZ=G_J\fV/\u001a:z?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0006-\u0005cA\u000b\u0002\b&\u0019\u0011\u0011\u0012\f\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003\u001b\u000by(!AA\u0002\u0005e\u0014a\u0001=%c!A\u0011\u0011S@!B\u0013\tI(\u0001\bsK\u0006$\u0017PR8s#V,'/\u001f\u0011\t\u0013\u0005UuP1A\u0005\n\u0005]\u0015a\u00049be\u0006lW\r^3s'R\fG/^:\u0016\u0005\u0005e\u0005\u0003CAN\u0003K\u000bI+!+\u000e\u0005\u0005u%\u0002BAP\u0003C\u000bq!\\;uC\ndWMC\u0002\u0002$Z\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9+!(\u0003\u000f!\u000b7\u000f['baB!\u00111VAY\u001d\r)\u0012QV\u0005\u0004\u0003_3\u0012A\u0002)sK\u0012,g-C\u0002D\u0003gS1!a,\u0017\u0011!\t9l Q\u0001\n\u0005e\u0015\u0001\u00059be\u0006lW\r^3s'R\fG/^:!\u0011%\tYl b\u0001\n\u0013\ti,\u0001\tqCJ\u001cX\rZ*uCR,W.\u001a8ugV\u0011\u0011q\u0018\t\t\u00037\u000b)+!+\u0002BB\u0019\u0001#a1\n\u0007\u0005\u0015'AA\fQe\u0016\u0004\u0018M]3e'R\fG/Z7f]RDu\u000e\u001c3fe\"A\u0011\u0011Z@!\u0002\u0013\ty,A\tqCJ\u001cX\rZ*uCR,W.\u001a8ug\u0002B\u0011\"!4\u0000\u0001\u0004%I!a\u001e\u0002\u001b\u0005,H\u000f[3oi&\u001c\u0017\r^3e\u0011%\t\tn a\u0001\n\u0013\t\u0019.A\tbkRDWM\u001c;jG\u0006$X\rZ0%KF$B!!\"\u0002V\"Q\u0011QRAh\u0003\u0003\u0005\r!!\u001f\t\u0011\u0005ew\u0010)Q\u0005\u0003s\na\"Y;uQ\u0016tG/[2bi\u0016$\u0007\u0005C\u0005\u0002^~\u0014\r\u0011\"\u0003\u0002`\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8GkR,(/Z\u000b\u0003\u0003C\u0004Ra_Ar\u0003\u001fI1!!:}\u0005\u001d\u0001&o\\7jg\u0016D\u0001\"!;\u0000A\u0003%\u0011\u0011]\u0001\u0012G>tg.Z2uS>tg)\u001e;ve\u0016\u0004\u0003\"CAw\u007f\u0002\u0007I\u0011BA<\u0003-\u0011XmY3oi\u0016\u0013(o\u001c:\t\u0013\u0005Ex\u00101A\u0005\n\u0005M\u0018a\u0004:fG\u0016tG/\u0012:s_J|F%Z9\u0015\t\u0005\u0015\u0015Q\u001f\u0005\u000b\u0003\u001b\u000by/!AA\u0002\u0005e\u0004\u0002CA}\u007f\u0002\u0006K!!\u001f\u0002\u0019I,7-\u001a8u\u000bJ\u0014xN\u001d\u0011\t\u0013\u0005uxP1A\u0005\n\u0005}\u0018!F9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-Z\u000b\u0003\u0005\u0003\u0001RA\fB\u0002\u0005\u000fI1A!\u00020\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007#B\u000b\u0003\n\t5\u0011b\u0001B\u0006-\t1q\n\u001d;j_:\u0004Ra_Ar\u0005\u001f\u00012a\u0013B\t\u0013\r\u0011\u0019\u0002\u0002\u0002\f#V,'/\u001f*fgVdG\u000f\u0003\u0005\u0003\u0018}\u0004\u000b\u0011\u0002B\u0001\u0003Y\tX/\u001a:z!J|W.[:f%\u00164WM]3oG\u0016\u0004\u0003\"\u0003B\u000e\u007f\u0002\u0007I\u0011\u0002B\u000f\u00031\u0019WO\u001d:f]R\fV/\u001a:z+\t\u0011y\u0002E\u0003\u0016\u0005\u0013\u0011\t\u0003\u0005\u0004\u0003$\t%\"QF\u0007\u0003\u0005KQ1Aa\n\u0005\u0003\u001d9WM\\3sC2LAAa\u000b\u0003&\t\u0001R*\u001e;bE2,'+Z:vYR\u001cV\r\u001e\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u001d\u0011\u0017mY6f]\u0012T1Aa\u000e\u0003\u0003!iWm]:bO\u0016\u001c\u0018\u0002\u0002B\u001e\u0005c\u0011A\u0003U8ti\u001e\u0014XmU)M\u0007>dW/\u001c8ECR\f\u0007\"\u0003B \u007f\u0002\u0007I\u0011\u0002B!\u0003A\u0019WO\u001d:f]R\fV/\u001a:z?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\n\r\u0003BCAG\u0005{\t\t\u00111\u0001\u0003 !A!qI@!B\u0013\u0011y\"A\u0007dkJ\u0014XM\u001c;Rk\u0016\u0014\u0018\u0010\t\u0005\n\u0005\u0017z\b\u0019!C\u0005\u0005\u001b\n\u0001dY;se\u0016tG\u000f\u0015:fa\u0006\u0014X\rZ*uCR,W.\u001a8u+\t\u0011y\u0005E\u0003\u0016\u0005\u0013\tI\u000bC\u0005\u0003T}\u0004\r\u0011\"\u0003\u0003V\u0005a2-\u001e:sK:$\bK]3qCJ,Gm\u0015;bi\u0016lWM\u001c;`I\u0015\fH\u0003BAC\u0005/B!\"!$\u0003R\u0005\u0005\t\u0019\u0001B(\u0011!\u0011Yf Q!\n\t=\u0013!G2veJ,g\u000e\u001e)sKB\f'/\u001a3Ti\u0006$X-\\3oi\u0002B\u0011Ba\u0018\u0000\u0001\u0004%IA!\u0019\u0002\u000fY,'o]5p]V\u0011!1\r\t\u0005\u0005K\u0012I'\u0004\u0002\u0003h)\u0011A\u0007B\u0005\u0005\u0005W\u00129GA\u0004WKJ\u001c\u0018n\u001c8\t\u0013\t=t\u00101A\u0005\n\tE\u0014a\u0003<feNLwN\\0%KF$B!!\"\u0003t!Q\u0011Q\u0012B7\u0003\u0003\u0005\rAa\u0019\t\u0011\t]t\u0010)Q\u0005\u0005G\n\u0001B^3sg&|g\u000e\t\u0005\n\u0005wz\b\u0019!C\u0005\u0005{\n1\"];fef\u0014Vm];miV\u0011!q\u0010\t\u0006+\t%!q\u0002\u0005\n\u0005\u0007{\b\u0019!C\u0005\u0005\u000b\u000bq\"];fef\u0014Vm];mi~#S-\u001d\u000b\u0005\u0003\u000b\u00139\t\u0003\u0006\u0002\u000e\n\u0005\u0015\u0011!a\u0001\u0005\u007fB\u0001Ba#\u0000A\u0003&!qP\u0001\rcV,'/\u001f*fgVdG\u000f\t\u0005\b\u0005\u001f{H\u0011AA<\u0003=I7OU3bIf4uN])vKJL\bb\u0002BJ\u007f\u0012\u0005!QS\u0001\bG>tg.Z2u+\t\u00119\nE\u0003|\u00053\u000by!C\u0002\u0003\u001cr\u0014aAR;ukJ,\u0007b\u0002BP\u007f\u0012\u0005#QS\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bb\u0002BR\u007f\u0012\u0005\u0013qO\u0001\fSN\u001cuN\u001c8fGR,G\rC\u0004\u0003(~$\tA!+\u0002#A\f'/Y7fi\u0016\u00148\u000b^1ukN,7/\u0006\u0002\u0003,BA!Q\u0016BZ\u0003S\u000bI+\u0004\u0002\u00030*!!\u0011WAQ\u0003%IW.\\;uC\ndW-\u0003\u0003\u00036\n=&aA'ba\"9!\u0011X@\u0005B\tm\u0016!C:f]\u0012\fV/\u001a:z)\u0011\u0011iLa0\u0011\u000bm\u0014IJa\u0004\t\u0011\t\u0005'q\u0017a\u0001\u0003S\u000bQ!];fefDqA!2\u0000\t\u0003\u00129-A\u000btK:$\u0007K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0015\r\tu&\u0011\u001aBf\u0011!\u0011\tMa1A\u0002\u0005%\u0006B\u0003Bg\u0005\u0007\u0004\n\u00111\u0001\u0003P\u00061a/\u00197vKN\u0004bA!5\u0003b\n\u001dh\u0002\u0002Bj\u0005;tAA!6\u0003\\6\u0011!q\u001b\u0006\u0004\u00053t\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\r\u0011yNF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019O!:\u0003\u0007M+\u0017OC\u0002\u0003`Z\u00012!\u0006Bu\u0013\r\u0011YO\u0006\u0002\u0004\u0003:L\bb\u0002Bx\u007f\u0012%!\u0011_\u0001\tSN\u0004\u0016M]:fIR!!1\u001fB{!\u0015)\"\u0011BAa\u0011!\u0011\tM!<A\u0002\u0005%\u0006b\u0002B}\u007f\u0012\u0005#1`\u0001\b_:,%O]8s)\u0011\t)I!@\t\u0011\t}(q\u001fa\u0001\u0007\u0003\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\tE71A\u0005\u0005\u0007\u000b\u0011)OA\u0005UQJ|w/\u00192mK\"91\u0011B@\u0005\u0002\u0005]\u0014A\u00045bgJ+7-\u001a8u\u000bJ\u0014xN\u001d\u0005\b\u0007\u001byH\u0011BB\b\u0003E\u0019X\r^#se>\u0014xJ\u001c$viV\u0014Xm\u001d\u000b\u0005\u0003\u000b\u001b\t\u0002\u0003\u0005\u0004\u0014\r-\u0001\u0019AB\u0001\u0003\u0005)\u0007bBB\f\u007f\u0012\u00053\u0011D\u0001\u0010_:\u0014V-\u00193z\r>\u0014\u0018+^3ssR\u0011\u0011Q\u0011\u0005\b\u0005s|H\u0011IB\u000f)\u0011\t)ia\b\t\u0011\r\u000521\u0004a\u0001\u0007G\t\u0011!\u001c\t\u0005\u0005_\u0019)#\u0003\u0003\u0004(\tE\"\u0001D#se>\u0014X*Z:tC\u001e,\u0007bBB\u0016\u007f\u0012\u00053QF\u0001\u0012_:\u001cu.\\7b]\u0012\u001cu.\u001c9mKR,G\u0003BAC\u0007_A\u0001b!\t\u0004*\u0001\u00071\u0011\u0007\t\u0005\u0005_\u0019\u0019$\u0003\u0003\u00046\tE\"AF\"p[6\fg\u000eZ\"p[BdW\r^3NKN\u001c\u0018mZ3\t\u000f\rer\u0010\"\u0011\u0004<\u0005\trN\u001c)be\u0006lW\r^3s'R\fG/^:\u0015\t\u0005\u00155Q\b\u0005\t\u0007C\u00199\u00041\u0001\u0004@A!!qFB!\u0013\u0011\u0019\u0019E!\r\u0003-A\u000b'/Y7fi\u0016\u00148\u000b^1ukNlUm]:bO\u0016Dqaa\u0012\u0000\t\u0003\u001aI%A\u0005p]\u0012\u000bG/\u0019*poR!\u0011QQB&\u0011!\u0019\tc!\u0012A\u0002\r5\u0003\u0003\u0002B\u0018\u0007\u001fJAa!\u0015\u00032\tqA)\u0019;b%><X*Z:tC\u001e,\u0007bBB+\u007f\u0012\u00053qK\u0001\u0011_:\u0014vn\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!!\"\u0004Z!A1\u0011EB*\u0001\u0004\u0019Y\u0006\u0005\u0003\u00030\ru\u0013\u0002BB0\u0005c\u0011QCU8x\t\u0016\u001c8M]5qi&|g.T3tg\u0006<W\rC\u0004\u0004d}$Ia!\u001a\u0002\u001dM,GoQ8mk6tG)\u0019;bgR!\u0011QQB4\u0011!\u0019Ig!\u0019A\u0002\r-\u0014aC2pYVlg\u000eR1uCN\u0004R!FB7\u0005[I1aa\u001c\u0017\u0005\u0015\t%O]1z\u0011\u001d\u0019\u0019h C!\u0007k\n\u0001d\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\t)ia\u001e\t\u0011\re4\u0011\u000fa\u0001\u0007w\nq!\\3tg\u0006<W\r\u0005\u0003\u00030\ru\u0014\u0002BB@\u0005c\u0011Q#Q;uQ\u0016tG/[2bi&|g.T3tg\u0006<W\rC\u0004\u0004\u0004~$Ia!\"\u0002\u0015\r\u0014X\rZ3oi&\fG\u000e\u0006\u0003\u0004\b\u000eM\u0005\u0003BBE\u0007\u001fk!aa#\u000b\t\r5%QG\u0001\tMJ|g\u000e^3oI&!1\u0011SBF\u0005E\u0019%/\u001a3f]RL\u0017\r\\'fgN\fw-\u001a\u0005\t\u0007+\u001b\t\t1\u0001\u0004\u0018\u0006)\u0012-\u001e;iK:$\u0018nY1uS>tW*Z:tC\u001e,\u0007\u0003\u0002B\u0018\u00073KAaa'\u00032\tq\u0012)\u001e;iK:$\u0018nY1uS>t7\t[1mY\u0016tw-Z'fgN\fw-\u001a\u0005\b\u0007?{H\u0011ABQ\u0003m1\u0018\r\\5eCR,\u0017JZ%u\u0013N\u0014V-\u00193z\r>\u0014\u0018+^3ssR!\u0011QQBR\u0011!\u0019)k!(A\u0002\u0005%\u0016\u0001D3se>\u0014X*Z:tC\u001e,\u0007bBBU\u007f\u0012%11V\u0001\u000em\u0006d\u0017\u000eZ1uKF+XM]=\u0015\t\u0005\u00155Q\u0016\u0005\t\u0005\u0003\u001c9\u000b1\u0001\u0002*\"91\u0011W@\u0005\n\rM\u0016\u0001D9vKJL\bK]8nSN,WC\u0001B\u0004\u0011\u001d\u00199l C\u0005\u0007s\u000bqb]3u#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u000b\u001bY\f\u0003\u0005\u0004>\u000eU\u0006\u0019\u0001B\u0007\u0003\u001d\u0001(o\\7jg\u0016Dqa!1\u0000\t\u0013\u0019\u0019-A\tdY\u0016\f'/U;fef\u0004&o\\7jg\u0016,\"!!\"\t\u000f\r\u001dw\u0010\"\u0003\u0004J\u0006\u0001b-Y5m#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u000b\u001bY\r\u0003\u0005\u0004N\u000e\u0015\u0007\u0019AB\u0001\u0003\u0005!\bbBBi\u007f\u0012%11[\u0001\u0014gV\u001c7-Z3e#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003\u000b\u001b)\u000e\u0003\u0005\u0004X\u000e=\u0007\u0019\u0001B\b\u0003\u0019\u0011Xm];mi\"911\\@\u0005\u0002\ru\u0017!B<sSR,G\u0003BAC\u0007?D\u0001b!\u001f\u0004Z\u0002\u00071\u0011\u001d\t\u0005\u0007\u0013\u001b\u0019/\u0003\u0003\u0004f\u000e-%!D\"mS\u0016tG/T3tg\u0006<W\rC\u0004\u0004j~$\tea;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!+\t\u0013\r=x0%A\u0005B\rE\u0018aH:f]\u0012\u0004&/\u001a9be\u0016$7\u000b^1uK6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\u001f\u0016\u0004\u0005\u001ft\u0005")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger preparedStatementsCounter;
    private final ExecutionContext internalExecutionContext;
    private boolean readyForQuery;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<String> currentPreparedStatement;
    private Version version;
    private Option<QueryResult> queryResult;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    private final AtomicInteger preparedStatementsCounter() {
        return this.preparedStatementsCounter;
    }

    private final ExecutionContext internalExecutionContext() {
        return this.internalExecutionContext;
    }

    private boolean readyForQuery() {
        return this.readyForQuery;
    }

    private void readyForQuery_$eq(boolean x$1) {
        this.readyForQuery = x$1;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    private HashMap<String, PreparedStatementHolder> parsedStatements() {
        return this.parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<String> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<String> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public boolean isReadyForQuery() {
        return this.readyForQuery();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final PostgreSQLConnection apply(PostgreSQLConnectionHandler c) {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        this.readyForQuery_$eq(false);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        Option<PreparedStatementHolder> option;
        block6: {
            Promise promise;
            block5: {
                String realQuery;
                block4: {
                    this.validateQuery(query);
                    IntRef paramsCount = new IntRef(0);
                    String string = realQuery = query.contains("?") ? ((StringBuilder)new StringOps(Predef$.MODULE$.augmentString(query)).foldLeft((Object)new StringBuilder(), (Function2)new Serializable(this, paramsCount){
                        public static final long serialVersionUID = 0L;
                        private final IntRef paramsCount$1;

                        public final StringBuilder apply(StringBuilder builder, char c) {
                            StringBuilder stringBuilder;
                            if (c == '?') {
                                ++this.paramsCount$1.elem;
                                stringBuilder = builder.append(new StringBuilder().append((Object)"$").append((Object)BoxesRunTime.boxToInteger((int)this.paramsCount$1.elem)).toString());
                            } else {
                                stringBuilder = builder.append(c);
                            }
                            return builder;
                        }
                        {
                            this.paramsCount$1 = paramsCount$1;
                        }
                    })).toString() : query;
                    if (paramsCount.elem != values.length()) {
                        throw new InsufficientParametersException(paramsCount.elem, values);
                    }
                    this.readyForQuery_$eq(false);
                    promise = Promise$.MODULE$.apply();
                    this.setQueryPromise((Promise<QueryResult>)promise);
                    this.currentPreparedStatement_$eq((Option<String>)new Some((Object)query));
                    option = this.isParsed(query);
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    PreparedStatementHolder holder = (PreparedStatementHolder)some.x();
                    this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])holder.columnDatas()))));
                    this.write(new PreparedStatementExecuteMessage(holder.statementId(), realQuery, values, this.encoderRegistry));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<PreparedStatementHolder> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                int statementId = this.preparedStatementsCounter().incrementAndGet();
                this.parsedStatements().put((Object)query, (Object)new PreparedStatementHolder(statementId));
                this.write(new PreparedStatementOpeningMessage(statementId, realQuery, values, this.encoderRegistry));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return promise.future();
        }
        throw new MatchError(option);
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    private Option<PreparedStatementHolder> isParsed(String query) {
        return this.parsedStatements().get((Object)query);
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().isCompleted()) {
            future = BoxedUnit.UNIT;
        } else {
            this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().failure(e);
            future = this.disconnect();
        }
        this.failQueryPromise(e);
        this.currentPreparedStatement_$eq((Option<String>)None$.MODULE$);
    }

    @Override
    public void onReadyForQuery() {
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().trySuccess((Object)this);
        this.queryResult().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final void apply(QueryResult result) {
                this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(result);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.recentError_$eq(false);
        this.readyForQuery_$eq(true);
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<String>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        String string = PostgreSQLConnection$.MODULE$.ServerVersionKey();
        String string2 = m.key();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[Predef$.MODULE$.refArrayOps((Object[])m.values()).size()];
        for (int x = 0; x < Predef$.MODULE$.refArrayOps((Object[])m.values()).size(); ++x) {
            Object object;
            if (m.values()[x] == null) {
                object = null;
            } else {
                PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                object = this.decoderRegistry.decode((ColumnData)columnType, m.values()[x], this.configuration.charset());
            }
            items[x] = object;
        }
        ((MutableResultSet)this.currentQuery().get()).addRow((Seq)Predef$.MODULE$.genericWrapArray((Object)items));
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        if (this.currentPreparedStatement().isDefined()) {
            PreparedStatementHolder holder = (PreparedStatementHolder)this.parsedStatements().apply(this.currentPreparedStatement().get());
            holder.columnDatas_$eq(columnDatas);
        }
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage;
        block5: {
            block3: {
                block4: {
                    block2: {
                        authenticationMessage = message;
                        if (!(authenticationMessage instanceof AuthenticationOkMessage)) break block2;
                        PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
                        this.authenticated_$eq(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(authenticationMessage instanceof AuthenticationChallengeCleartextMessage)) break block4;
                    AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
                    this.write(this.credential(authenticationChallengeCleartextMessage));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(authenticationMessage instanceof AuthenticationChallengeMD5)) break block5;
                AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
                this.write(this.credential(authenticationChallengeMD5));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            PostgreSQLConnection$.MODULE$.log().error(errorMessage);
            throw new ConnectionStillRunningQueryException(this.currentCount(), this.readyForQuery());
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        this.queryPromiseReference().set((Option<Promise<QueryResult>>)new Some(promise));
    }

    private void clearQueryPromise() {
        this.queryPromiseReference().set((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        Option<Promise<QueryResult>> promise = this.queryPromise();
        if (promise.isDefined()) {
            this.clearQueryPromise();
            PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
            ((Promise)promise.get()).failure(t);
        }
    }

    public void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(QueryResult result) {
        Option<Promise<QueryResult>> promise = this.queryPromise();
        if (promise.isDefined()) {
            this.clearQueryPromise();
            ((Promise)promise.get()).success((Object)result);
        }
    }

    public void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        Connection.class.$init$((Connection)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.preparedStatementsCounter = new AtomicInteger();
        this.internalExecutionContext = executionContext;
        this.readyForQuery = false;
        this.parameterStatus = new HashMap();
        this.parsedStatements = new HashMap();
        this.authenticated = false;
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.queryResult = None$.MODULE$;
    }
}

