/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.test;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import io.vavr.CheckedFunction3;
import io.vavr.CheckedFunction4;
import io.vavr.CheckedFunction5;
import io.vavr.CheckedFunction6;
import io.vavr.CheckedFunction7;
import io.vavr.CheckedFunction8;
import io.vavr.Tuple;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.test.Arbitrary;
import io.vavr.test.CheckResult;
import io.vavr.test.Checkable;
import io.vavr.test.Gen;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;

public class Property {
    private final String name;

    private Property(String name) {
        this.name = name;
    }

    public static Property def(String name) {
        Objects.requireNonNull(name, "name is null");
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
        return new Property(name);
    }

    private static void logSatisfied(String name, int tries, long millis, boolean exhausted) {
        if (exhausted) {
            Property.log(String.format("%s: Exhausted after %s tests in %s ms.", name, tries, millis));
        } else {
            Property.log(String.format("%s: OK, passed %s tests in %s ms.", name, tries, millis));
        }
    }

    private static void logFalsified(String name, int currentTry, long millis) {
        Property.log(String.format("%s: Falsified after %s passed tests in %s ms.", name, currentTry - 1, millis));
    }

    private static void logErroneous(String name, int currentTry, long millis, String errorMessage) {
        Property.log(String.format("%s: Errored after %s passed tests in %s ms with message: %s", name, Math.max(0, currentTry - 1), millis, errorMessage));
    }

    private static void log(String msg) {
        System.out.println(msg);
    }

    private static CheckError arbitraryError(int position, int size, Throwable cause) {
        return new CheckError(String.format("Arbitrary %s of size %s: %s", position, size, cause.getMessage()), cause);
    }

    private static CheckError genError(int position, int size, Throwable cause) {
        return new CheckError(String.format("Gen %s of size %s: %s", position, size, cause.getMessage()), cause);
    }

    private static CheckError predicateError(Throwable cause) {
        return new CheckError("Applying predicate: " + cause.getMessage(), cause);
    }

    public <T1> ForAll1<T1> forAll(Arbitrary<T1> a1) {
        return new ForAll1<T1>(this.name, a1);
    }

    public <T1, T2> ForAll2<T1, T2> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2) {
        return new ForAll2<T1, T2>(this.name, a1, a2);
    }

    public <T1, T2, T3> ForAll3<T1, T2, T3> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3) {
        return new ForAll3<T1, T2, T3>(this.name, a1, a2, a3);
    }

    public <T1, T2, T3, T4> ForAll4<T1, T2, T3, T4> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4) {
        return new ForAll4<T1, T2, T3, T4>(this.name, a1, a2, a3, a4);
    }

    public <T1, T2, T3, T4, T5> ForAll5<T1, T2, T3, T4, T5> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5) {
        return new ForAll5<T1, T2, T3, T4, T5>(this.name, a1, a2, a3, a4, a5);
    }

    public <T1, T2, T3, T4, T5, T6> ForAll6<T1, T2, T3, T4, T5, T6> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6) {
        return new ForAll6<T1, T2, T3, T4, T5, T6>(this.name, a1, a2, a3, a4, a5, a6);
    }

    public <T1, T2, T3, T4, T5, T6, T7> ForAll7<T1, T2, T3, T4, T5, T6, T7> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7) {
        return new ForAll7<T1, T2, T3, T4, T5, T6, T7>(this.name, a1, a2, a3, a4, a5, a6, a7);
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> ForAll8<T1, T2, T3, T4, T5, T6, T7, T8> forAll(Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, Arbitrary<T8> a8) {
        return new ForAll8<T1, T2, T3, T4, T5, T6, T7, T8>(this.name, a1, a2, a3, a4, a5, a6, a7, a8);
    }

    static class CheckError
    extends Error {
        private static final long serialVersionUID = 1L;

        CheckError(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class ForAll1<T1> {
        private final String name;
        private final Arbitrary<T1> a1;

        ForAll1(String name, Arbitrary<T1> a1) {
            this.name = name;
            this.a1 = a1;
        }

        public Property1<T1> suchThat(CheckedFunction1<T1, Boolean> predicate) {
            CheckedFunction1 & Serializable proposition = (CheckedFunction1 & Serializable)t1 -> new Condition(true, (Boolean)predicate.apply(t1));
            return new Property1<T1>(this.name, this.a1, proposition);
        }
    }

    public static class ForAll2<T1, T2> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;

        ForAll2(String name, Arbitrary<T1> a1, Arbitrary<T2> a2) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
        }

        public Property2<T1, T2> suchThat(CheckedFunction2<T1, T2, Boolean> predicate) {
            CheckedFunction2 & Serializable proposition = (CheckedFunction2 & Serializable)(t1, t2) -> new Condition(true, (Boolean)predicate.apply(t1, t2));
            return new Property2<T1, T2>(this.name, this.a1, this.a2, proposition);
        }
    }

    public static class ForAll3<T1, T2, T3> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;

        ForAll3(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
        }

        public Property3<T1, T2, T3> suchThat(CheckedFunction3<T1, T2, T3, Boolean> predicate) {
            CheckedFunction3 & Serializable proposition = (CheckedFunction3 & Serializable)(t1, t2, t3) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3));
            return new Property3<T1, T2, T3>(this.name, this.a1, this.a2, this.a3, proposition);
        }
    }

    public static class ForAll4<T1, T2, T3, T4> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;

        ForAll4(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
        }

        public Property4<T1, T2, T3, T4> suchThat(CheckedFunction4<T1, T2, T3, T4, Boolean> predicate) {
            CheckedFunction4 & Serializable proposition = (CheckedFunction4 & Serializable)(t1, t2, t3, t4) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3, t4));
            return new Property4<T1, T2, T3, T4>(this.name, this.a1, this.a2, this.a3, this.a4, proposition);
        }
    }

    public static class ForAll5<T1, T2, T3, T4, T5> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;

        ForAll5(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
        }

        public Property5<T1, T2, T3, T4, T5> suchThat(CheckedFunction5<T1, T2, T3, T4, T5, Boolean> predicate) {
            CheckedFunction5 & Serializable proposition = (CheckedFunction5 & Serializable)(t1, t2, t3, t4, t5) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3, t4, t5));
            return new Property5<T1, T2, T3, T4, T5>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, proposition);
        }
    }

    public static class ForAll6<T1, T2, T3, T4, T5, T6> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;

        ForAll6(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
        }

        public Property6<T1, T2, T3, T4, T5, T6> suchThat(CheckedFunction6<T1, T2, T3, T4, T5, T6, Boolean> predicate) {
            CheckedFunction6 & Serializable proposition = (CheckedFunction6 & Serializable)(t1, t2, t3, t4, t5, t6) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3, t4, t5, t6));
            return new Property6<T1, T2, T3, T4, T5, T6>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, proposition);
        }
    }

    public static class ForAll7<T1, T2, T3, T4, T5, T6, T7> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;

        ForAll7(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
        }

        public Property7<T1, T2, T3, T4, T5, T6, T7> suchThat(CheckedFunction7<T1, T2, T3, T4, T5, T6, T7, Boolean> predicate) {
            CheckedFunction7 & Serializable proposition = (CheckedFunction7 & Serializable)(t1, t2, t3, t4, t5, t6, t7) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3, t4, t5, t6, t7));
            return new Property7<T1, T2, T3, T4, T5, T6, T7>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7, proposition);
        }
    }

    public static class ForAll8<T1, T2, T3, T4, T5, T6, T7, T8> {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;
        private final Arbitrary<T8> a8;

        ForAll8(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, Arbitrary<T8> a8) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
            this.a8 = a8;
        }

        public Property8<T1, T2, T3, T4, T5, T6, T7, T8> suchThat(CheckedFunction8<T1, T2, T3, T4, T5, T6, T7, T8, Boolean> predicate) {
            CheckedFunction8 & Serializable proposition = (CheckedFunction8 & Serializable)(t1, t2, t3, t4, t5, t6, t7, t8) -> new Condition(true, (Boolean)predicate.apply(t1, t2, t3, t4, t5, t6, t7, t8));
            return new Property8<T1, T2, T3, T4, T5, T6, T7, T8>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7, this.a8, proposition);
        }
    }

    static class Condition {
        static final Condition EX_FALSO_QUODLIBET = new Condition(false, true);
        final boolean precondition;
        final boolean postcondition;

        Condition(boolean precondition, boolean postcondition) {
            this.precondition = precondition;
            this.postcondition = postcondition;
        }

        boolean isFalse() {
            return this.precondition && !this.postcondition;
        }
    }

    public static class Property8<T1, T2, T3, T4, T5, T6, T7, T8>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;
        private final Arbitrary<T8> a8;
        private final CheckedFunction8<T1, T2, T3, T4, T5, T6, T7, T8, Condition> predicate;

        Property8(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, Arbitrary<T8> a8, CheckedFunction8<T1, T2, T3, T4, T5, T6, T7, T8, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
            this.a8 = a8;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction8<T1, T2, T3, T4, T5, T6, T7, T8, Boolean> postcondition) {
            CheckedFunction8 & Serializable implication = (CheckedFunction8 & Serializable)(t1, t2, t3, t4, t5, t6, t7, t8) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3, t4, t5, t6, t7, t8);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3, t4, t5, t6, t7, t8));
            };
            return new Property8<T1, T2, T3, T4, T5, T6, T7, T8>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7, this.a8, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                Gen gen4 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a4.apply(size)).recover(x -> {
                    throw Property.arbitraryError(4, size, x);
                }).get();
                Gen gen5 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a5.apply(size)).recover(x -> {
                    throw Property.arbitraryError(5, size, x);
                }).get();
                Gen gen6 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a6.apply(size)).recover(x -> {
                    throw Property.arbitraryError(6, size, x);
                }).get();
                Gen gen7 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a7.apply(size)).recover(x -> {
                    throw Property.arbitraryError(7, size, x);
                }).get();
                Gen gen8 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a8.apply(size)).recover(x -> {
                    throw Property.arbitraryError(8, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        Object val4 = Try.of((CheckedFunction0 & Serializable)() -> gen4.apply(random)).recover(x -> {
                            throw Property.genError(4, size, x);
                        }).get();
                        Object val5 = Try.of((CheckedFunction0 & Serializable)() -> gen5.apply(random)).recover(x -> {
                            throw Property.genError(5, size, x);
                        }).get();
                        Object val6 = Try.of((CheckedFunction0 & Serializable)() -> gen6.apply(random)).recover(x -> {
                            throw Property.genError(6, size, x);
                        }).get();
                        Object val7 = Try.of((CheckedFunction0 & Serializable)() -> gen7.apply(random)).recover(x -> {
                            throw Property.genError(7, size, x);
                        }).get();
                        Object val8 = Try.of((CheckedFunction0 & Serializable)() -> gen8.apply(random)).recover(x -> {
                            throw Property.genError(8, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3, val4, val5, val6, val7, val8)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6, (Object)val7, (Object)val8));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6, (Object)val7, (Object)val8)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property7<T1, T2, T3, T4, T5, T6, T7>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final Arbitrary<T7> a7;
        private final CheckedFunction7<T1, T2, T3, T4, T5, T6, T7, Condition> predicate;

        Property7(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, Arbitrary<T7> a7, CheckedFunction7<T1, T2, T3, T4, T5, T6, T7, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.a7 = a7;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction7<T1, T2, T3, T4, T5, T6, T7, Boolean> postcondition) {
            CheckedFunction7 & Serializable implication = (CheckedFunction7 & Serializable)(t1, t2, t3, t4, t5, t6, t7) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3, t4, t5, t6, t7);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3, t4, t5, t6, t7));
            };
            return new Property7<T1, T2, T3, T4, T5, T6, T7>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, this.a7, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                Gen gen4 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a4.apply(size)).recover(x -> {
                    throw Property.arbitraryError(4, size, x);
                }).get();
                Gen gen5 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a5.apply(size)).recover(x -> {
                    throw Property.arbitraryError(5, size, x);
                }).get();
                Gen gen6 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a6.apply(size)).recover(x -> {
                    throw Property.arbitraryError(6, size, x);
                }).get();
                Gen gen7 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a7.apply(size)).recover(x -> {
                    throw Property.arbitraryError(7, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        Object val4 = Try.of((CheckedFunction0 & Serializable)() -> gen4.apply(random)).recover(x -> {
                            throw Property.genError(4, size, x);
                        }).get();
                        Object val5 = Try.of((CheckedFunction0 & Serializable)() -> gen5.apply(random)).recover(x -> {
                            throw Property.genError(5, size, x);
                        }).get();
                        Object val6 = Try.of((CheckedFunction0 & Serializable)() -> gen6.apply(random)).recover(x -> {
                            throw Property.genError(6, size, x);
                        }).get();
                        Object val7 = Try.of((CheckedFunction0 & Serializable)() -> gen7.apply(random)).recover(x -> {
                            throw Property.genError(7, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3, val4, val5, val6, val7)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6, (Object)val7));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6, (Object)val7)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property6<T1, T2, T3, T4, T5, T6>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final Arbitrary<T6> a6;
        private final CheckedFunction6<T1, T2, T3, T4, T5, T6, Condition> predicate;

        Property6(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, Arbitrary<T6> a6, CheckedFunction6<T1, T2, T3, T4, T5, T6, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.a6 = a6;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction6<T1, T2, T3, T4, T5, T6, Boolean> postcondition) {
            CheckedFunction6 & Serializable implication = (CheckedFunction6 & Serializable)(t1, t2, t3, t4, t5, t6) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3, t4, t5, t6);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3, t4, t5, t6));
            };
            return new Property6<T1, T2, T3, T4, T5, T6>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, this.a6, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                Gen gen4 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a4.apply(size)).recover(x -> {
                    throw Property.arbitraryError(4, size, x);
                }).get();
                Gen gen5 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a5.apply(size)).recover(x -> {
                    throw Property.arbitraryError(5, size, x);
                }).get();
                Gen gen6 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a6.apply(size)).recover(x -> {
                    throw Property.arbitraryError(6, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        Object val4 = Try.of((CheckedFunction0 & Serializable)() -> gen4.apply(random)).recover(x -> {
                            throw Property.genError(4, size, x);
                        }).get();
                        Object val5 = Try.of((CheckedFunction0 & Serializable)() -> gen5.apply(random)).recover(x -> {
                            throw Property.genError(5, size, x);
                        }).get();
                        Object val6 = Try.of((CheckedFunction0 & Serializable)() -> gen6.apply(random)).recover(x -> {
                            throw Property.genError(6, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3, val4, val5, val6)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5, (Object)val6)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property5<T1, T2, T3, T4, T5>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final Arbitrary<T5> a5;
        private final CheckedFunction5<T1, T2, T3, T4, T5, Condition> predicate;

        Property5(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, Arbitrary<T5> a5, CheckedFunction5<T1, T2, T3, T4, T5, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.a5 = a5;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction5<T1, T2, T3, T4, T5, Boolean> postcondition) {
            CheckedFunction5 & Serializable implication = (CheckedFunction5 & Serializable)(t1, t2, t3, t4, t5) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3, t4, t5);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3, t4, t5));
            };
            return new Property5<T1, T2, T3, T4, T5>(this.name, this.a1, this.a2, this.a3, this.a4, this.a5, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                Gen gen4 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a4.apply(size)).recover(x -> {
                    throw Property.arbitraryError(4, size, x);
                }).get();
                Gen gen5 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a5.apply(size)).recover(x -> {
                    throw Property.arbitraryError(5, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        Object val4 = Try.of((CheckedFunction0 & Serializable)() -> gen4.apply(random)).recover(x -> {
                            throw Property.genError(4, size, x);
                        }).get();
                        Object val5 = Try.of((CheckedFunction0 & Serializable)() -> gen5.apply(random)).recover(x -> {
                            throw Property.genError(5, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3, val4, val5)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4, (Object)val5)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property4<T1, T2, T3, T4>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final Arbitrary<T4> a4;
        private final CheckedFunction4<T1, T2, T3, T4, Condition> predicate;

        Property4(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, Arbitrary<T4> a4, CheckedFunction4<T1, T2, T3, T4, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.a4 = a4;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction4<T1, T2, T3, T4, Boolean> postcondition) {
            CheckedFunction4 & Serializable implication = (CheckedFunction4 & Serializable)(t1, t2, t3, t4) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3, t4);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3, t4));
            };
            return new Property4<T1, T2, T3, T4>(this.name, this.a1, this.a2, this.a3, this.a4, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                Gen gen4 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a4.apply(size)).recover(x -> {
                    throw Property.arbitraryError(4, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        Object val4 = Try.of((CheckedFunction0 & Serializable)() -> gen4.apply(random)).recover(x -> {
                            throw Property.genError(4, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3, val4)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3, (Object)val4)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property3<T1, T2, T3>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final Arbitrary<T3> a3;
        private final CheckedFunction3<T1, T2, T3, Condition> predicate;

        Property3(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, Arbitrary<T3> a3, CheckedFunction3<T1, T2, T3, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.a3 = a3;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction3<T1, T2, T3, Boolean> postcondition) {
            CheckedFunction3 & Serializable implication = (CheckedFunction3 & Serializable)(t1, t2, t3) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2, t3);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2, t3));
            };
            return new Property3<T1, T2, T3>(this.name, this.a1, this.a2, this.a3, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                Gen gen3 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a3.apply(size)).recover(x -> {
                    throw Property.arbitraryError(3, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        Object val3 = Try.of((CheckedFunction0 & Serializable)() -> gen3.apply(random)).recover(x -> {
                            throw Property.genError(3, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2, val3)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2, (Object)val3));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2, (Object)val3)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property2<T1, T2>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final Arbitrary<T2> a2;
        private final CheckedFunction2<T1, T2, Condition> predicate;

        Property2(String name, Arbitrary<T1> a1, Arbitrary<T2> a2, CheckedFunction2<T1, T2, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.a2 = a2;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction2<T1, T2, Boolean> postcondition) {
            CheckedFunction2 & Serializable implication = (CheckedFunction2 & Serializable)(t1, t2) -> {
                Condition precondition = (Condition)this.predicate.apply(t1, t2);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1, t2));
            };
            return new Property2<T1, T2>(this.name, this.a1, this.a2, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                Gen gen2 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a2.apply(size)).recover(x -> {
                    throw Property.arbitraryError(2, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        Object val2 = Try.of((CheckedFunction0 & Serializable)() -> gen2.apply(random)).recover(x -> {
                            throw Property.genError(2, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1, val2)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1, (Object)val2));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1, (Object)val2)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }

    public static class Property1<T1>
    implements Checkable {
        private final String name;
        private final Arbitrary<T1> a1;
        private final CheckedFunction1<T1, Condition> predicate;

        Property1(String name, Arbitrary<T1> a1, CheckedFunction1<T1, Condition> predicate) {
            this.name = name;
            this.a1 = a1;
            this.predicate = predicate;
        }

        public Checkable implies(CheckedFunction1<T1, Boolean> postcondition) {
            CheckedFunction1 & Serializable implication = (CheckedFunction1 & Serializable)t1 -> {
                Condition precondition = (Condition)this.predicate.apply(t1);
                if (precondition.isFalse()) {
                    return Condition.EX_FALSO_QUODLIBET;
                }
                return new Condition(true, (Boolean)postcondition.apply(t1));
            };
            return new Property1<T1>(this.name, this.a1, implication);
        }

        @Override
        public CheckResult check(Random random, int size, int tries) {
            Objects.requireNonNull(random, "random is null");
            if (tries < 0) {
                throw new IllegalArgumentException("tries < 0");
            }
            long startTime = System.currentTimeMillis();
            try {
                Gen gen1 = (Gen)Try.of((CheckedFunction0 & Serializable)() -> this.a1.apply(size)).recover(x -> {
                    throw Property.arbitraryError(1, size, x);
                }).get();
                boolean exhausted = true;
                for (int i = 1; i <= tries; ++i) {
                    try {
                        Object val1 = Try.of((CheckedFunction0 & Serializable)() -> gen1.apply(random)).recover(x -> {
                            throw Property.genError(1, size, x);
                        }).get();
                        try {
                            Condition condition = (Condition)Try.of((CheckedFunction0 & Serializable)() -> (Condition)this.predicate.apply(val1)).recover(x -> {
                                throw Property.predicateError(x);
                            }).get();
                            if (!condition.precondition) continue;
                            exhausted = false;
                            if (condition.postcondition) continue;
                            Property.logFalsified(this.name, i, System.currentTimeMillis() - startTime);
                            return new CheckResult.Falsified(this.name, i, (Tuple)Tuple.of((Object)val1));
                        }
                        catch (CheckError err) {
                            Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                            return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.some((Object)Tuple.of((Object)val1)));
                        }
                    }
                    catch (CheckError err) {
                        Property.logErroneous(this.name, i, System.currentTimeMillis() - startTime, err.getMessage());
                        return new CheckResult.Erroneous(this.name, i, err, (Option<Tuple>)Option.none());
                    }
                }
                Property.logSatisfied(this.name, tries, System.currentTimeMillis() - startTime, exhausted);
                return new CheckResult.Satisfied(this.name, tries, exhausted);
            }
            catch (CheckError err) {
                Property.logErroneous(this.name, 0, System.currentTimeMillis() - startTime, err.getMessage());
                return new CheckResult.Erroneous(this.name, 0, err, (Option<Tuple>)Option.none());
            }
        }
    }
}

