/*
 * Decompiled with CFR 0.152.
 */
package io.valkey.params;

import io.valkey.CommandArguments;
import io.valkey.Protocol;
import io.valkey.args.SaveMode;
import io.valkey.params.IParams;
import java.util.Objects;

public class ShutdownParams
implements IParams {
    private SaveMode saveMode;
    private boolean now;
    private boolean force;

    public static ShutdownParams shutdownParams() {
        return new ShutdownParams();
    }

    public ShutdownParams saveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
        return this;
    }

    public ShutdownParams nosave() {
        return this.saveMode(SaveMode.NOSAVE);
    }

    public ShutdownParams save() {
        return this.saveMode(SaveMode.SAVE);
    }

    public ShutdownParams now() {
        this.now = true;
        return this;
    }

    public ShutdownParams force() {
        this.force = true;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.saveMode != null) {
            args.add(this.saveMode);
        }
        if (this.now) {
            args.add(Protocol.Keyword.NOW);
        }
        if (this.force) {
            args.add(Protocol.Keyword.FORCE);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShutdownParams that = (ShutdownParams)o;
        return this.now == that.now && this.force == that.force && this.saveMode == that.saveMode;
    }

    public int hashCode() {
        return Objects.hash(this.saveMode, this.now, this.force);
    }
}

