/*
 * Decompiled with CFR 0.152.
 */
package io.validly;

import java.util.Objects;
import java.util.function.Predicate;

class PredicateUtil {
    PredicateUtil() {
    }

    static Predicate<String> isNotEmpty() {
        return v -> !PredicateUtil.isEmptyString(v);
    }

    static Predicate<String> isNotTrimmedEmpty() {
        return v -> !PredicateUtil.isTrimmedEmptyString(v);
    }

    static Predicate<String> isNotBlank() {
        return v -> !PredicateUtil.isBlank(v);
    }

    static Predicate<String> isWithinMax(int max) {
        return v -> Objects.isNull(v) || v.length() <= max;
    }

    static Predicate<String> isWithinMin(int min) {
        return v -> Objects.nonNull(v) && v.length() >= min;
    }

    static Predicate<Integer> maxValue(int max) {
        return v -> v <= max;
    }

    static Predicate<Integer> minValue(int min) {
        return v -> v >= min;
    }

    private static boolean isEmptyString(String v) {
        return Objects.nonNull(v) && v.isEmpty();
    }

    private static boolean isTrimmedEmptyString(String v) {
        return Objects.nonNull(v) && !v.trim().isEmpty();
    }

    private static boolean isBlank(String v) {
        int strLen;
        if (v == null || (strLen = v.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(v.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

