/*
 * Decompiled with CFR 0.152.
 */
package io.validly;

import io.validly.Then;
import io.validly.ValidationEngine;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public class PreCondition<T, FV extends ValidationEngine> {
    protected final ValidationEngine<T, FV> validationEngine;

    PreCondition(ValidationEngine<T, FV> validationEngine) {
        this.validationEngine = validationEngine;
    }

    public ValidationEngine<T, ? extends ValidationEngine> mustNotBeNull(String message) {
        this.validationEngine.setNullIsValid(false);
        this.validationEngine.mustFatally(Objects::nonNull, message);
        return this.validationEngine;
    }

    public ValidationEngine<T, ? extends ValidationEngine> canBeNull() {
        this.validationEngine.setNullIsValid(true);
        return this.validationEngine;
    }

    public ValidationEngine<T, ? extends ValidationEngine> mustNotBeNullWhen(boolean mustNotBeNull, String message) {
        if (mustNotBeNull) {
            return this.mustNotBeNull(message);
        }
        return this.canBeNull();
    }

    public PreCondition<T, ? extends ValidationEngine> validateWhen(boolean validate) {
        this.validationEngine.setIgnore(!validate);
        return this;
    }

    @SafeVarargs
    public final ValidationEngine<T, ? extends ValidationEngine> when(boolean value, Then<T> ... thenPredicates) {
        if (value) {
            Arrays.stream(thenPredicates).forEach(p -> this.validationEngine.mustFatally(p.getPredicate(), p.getMessage()));
        }
        return this.validationEngine;
    }

    public ValidationEngine<T, ? extends ValidationEngine> must(Predicate<T> predicate, String message) {
        return this.validationEngine.must(predicate, message);
    }
}

