/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import com.globalmentor.itu.TelephoneNumber;
import com.globalmentor.java.Bytes;
import com.globalmentor.java.CodePointCharacter;
import com.globalmentor.net.EmailAddress;
import io.urf.surf.SurfTestResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractSimpleGraphSurfParserTest<SO> {
    protected Optional<Object> parseTestResource(@Nonnull String testResourceName) throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream(testResourceName);){
            Optional<Object> optional = this.parseTestResource(inputStream);
            return optional;
        }
    }

    protected abstract Optional<Object> parseTestResource(@Nonnull InputStream var1) throws IOException;

    protected abstract Class<SO> getSurfObjectClass();

    public abstract Optional<String> getTypeHandle(@Nonnull SO var1);

    protected abstract int getPropertyCount(@Nonnull SO var1);

    public abstract Optional<Object> getPropertyValue(@Nonnull SO var1, @Nonnull String var2);

    @Test
    public void testOkSimpleResources() throws IOException {
        for (String okSimpleResourceName : SurfTestResources.OK_SIMPLE_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okSimpleResourceName);
            Assert.assertThat((String)okSimpleResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSimpleResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(this.getSurfObjectClass())));
            Object resource = object.get();
            Assert.assertThat((String)okSimpleResourceName, this.getTypeHandle(resource), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okSimpleResourceName, (Object)this.getPropertyCount(resource), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkObjectNoProperties() throws IOException {
        for (String okObjectNoPropertiesResourceName : SurfTestResources.OK_OBJECT_NO_PROPERTIES_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okObjectNoPropertiesResourceName);
            Assert.assertThat((String)okObjectNoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectNoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(this.getSurfObjectClass())));
            Object resource = object.get();
            Assert.assertThat((String)okObjectNoPropertiesResourceName, this.getTypeHandle(resource), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectNoPropertiesResourceName, (Object)this.getPropertyCount(resource), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkObjectOneProperty() throws IOException {
        for (String okObjectOnePropertyResourceName : SurfTestResources.OK_OBJECT_ONE_PROPERTY_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okObjectOnePropertyResourceName);
            Assert.assertThat((String)okObjectOnePropertyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectOnePropertyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(this.getSurfObjectClass())));
            Object resource = object.get();
            Assert.assertThat((String)okObjectOnePropertyResourceName, this.getTypeHandle(resource), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)this.getPropertyCount(resource), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((String)okObjectOnePropertyResourceName, this.getPropertyValue(resource, "one"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectOnePropertyResourceName, this.getPropertyValue(resource, "one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"one"));
            Assert.assertThat((String)okObjectOnePropertyResourceName, this.getPropertyValue(resource, "two"), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
        }
    }

    @Test
    public void testOkObjectTwoProperties() throws IOException {
        for (String okObjectTwoPropertiesResourceName : SurfTestResources.OK_OBJECT_TWO_PROPERTIES_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okObjectTwoPropertiesResourceName);
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(this.getSurfObjectClass())));
            Object resource = object.get();
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getTypeHandle(resource), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)this.getPropertyCount(resource), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getPropertyValue(resource, "one"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getPropertyValue(resource, "one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"one"));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getPropertyValue(resource, "two"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getPropertyValue(resource, "two"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"two"));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, this.getPropertyValue(resource, "three"), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
        }
    }

    @Test
    public void testOkObjectType() throws IOException {
        for (String okObjectTypeResourceName : SurfTestResources.OK_OBJECT_TYPE_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okObjectTypeResourceName);
            Assert.assertThat((String)okObjectTypeResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTypeResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(this.getSurfObjectClass())));
            Object resource = object.get();
            Assert.assertThat((String)okObjectTypeResourceName, this.getTypeHandle(resource), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-FooBar"));
            Assert.assertThat((String)okObjectTypeResourceName, (Object)this.getPropertyCount(resource), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkBinary() throws IOException {
        Object resource = this.parseTestResource("ok-binary.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "count"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648Example1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3, -39, 126}));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648Example2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3, -39}));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648Example3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3}));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Bytes.NO_BYTES));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"f".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"fo".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foo".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foob".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector6"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"fooba".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat(this.getPropertyValue(resource, "rfc4648TestVector7"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foobar".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void testOkBooleanFalse() throws IOException {
        Optional<Object> object = this.parseTestResource("ok-boolean-false.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)Boolean.FALSE));
    }

    @Test
    public void testOkBooleanTrue() throws IOException {
        Optional<Object> object = this.parseTestResource("ok-boolean-true.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)Boolean.TRUE));
    }

    @Test
    public void testOkCharacters() throws IOException {
        Object resource = this.parseTestResource("ok-characters.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "foo"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'|')));
        Assert.assertThat(this.getPropertyValue(resource, "quote"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\"')));
        Assert.assertThat(this.getPropertyValue(resource, "apostrophe"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\'')));
        Assert.assertThat(this.getPropertyValue(resource, "backslash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\\')));
        Assert.assertThat(this.getPropertyValue(resource, "solidus"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'/')));
        Assert.assertThat(this.getPropertyValue(resource, "backspace"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\b')));
        Assert.assertThat(this.getPropertyValue(resource, "ff"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\f')));
        Assert.assertThat(this.getPropertyValue(resource, "lf"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\n')));
        Assert.assertThat(this.getPropertyValue(resource, "cr"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\r')));
        Assert.assertThat(this.getPropertyValue(resource, "tab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\t')));
        Assert.assertThat(this.getPropertyValue(resource, "vtab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u000b')));
        Assert.assertThat(this.getPropertyValue(resource, "devanagari-ma"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u092e')));
        Assert.assertThat(this.getPropertyValue(resource, "devanagari-maEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u092e')));
        Assert.assertThat(this.getPropertyValue(resource, "tearsOfJoy"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((int)128514)));
        Assert.assertThat(this.getPropertyValue(resource, "tearsOfJoyEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((int)128514)));
    }

    @Test
    public void testOkEmailAddresses() throws IOException {
        Object resource = this.parseTestResource("ok-email-addresses.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jdoe@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "dot"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "tag"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe+tag@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "dash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe-foo@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "x"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"x@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "dashedDomain"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"foo-bar@strange-example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "longTLD"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"example@s.solutions")));
    }

    @Test
    public void testOkIris() throws IOException {
        Object resource = this.parseTestResource("ok-iris.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://www.example.com/")));
        Assert.assertThat(this.getPropertyValue(resource, "iso_8859_1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://www.example.org/D\u00fcrst")));
        Assert.assertThat(this.getPropertyValue(resource, "encodedForbidden"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://xn--99zt52a.example.org/%E2%80%AE")));
        Assert.assertThat(this.getPropertyValue(resource, "encodedForbidden"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://xn--99zt52a.example.org/%E2%80%AE")));
        Assert.assertThat(this.getPropertyValue(resource, "mailto"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("mailto:jdoe@example.com")));
        Assert.assertThat(this.getPropertyValue(resource, "tel"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("tel:+12015550123")));
        Assert.assertThat(this.getPropertyValue(resource, "urn_uuid"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("urn:uuid:5623962b-22b1-4680-ae1c-7174a46144fc")));
        Assert.assertThat(this.getPropertyValue(resource, "isbn"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("urn:isbn:0-395-36341-1")));
    }

    @Test
    public void testOkNumbers() throws IOException {
        Object resource = this.parseTestResource("ok-numbers.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "zero"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0L));
        Assert.assertThat(this.getPropertyValue(resource, "zeroFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0.0));
        Assert.assertThat(this.getPropertyValue(resource, "one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)1L));
        Assert.assertThat(this.getPropertyValue(resource, "oneFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)1.0));
        Assert.assertThat(this.getPropertyValue(resource, "integer"), (Matcher)OptionalMatchers.isPresentAndIs((Object)123L));
        Assert.assertThat(this.getPropertyValue(resource, "negative"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-123L));
        Assert.assertThat(this.getPropertyValue(resource, "long"), (Matcher)OptionalMatchers.isPresentAndIs((Object)3456789123L));
        Assert.assertThat(this.getPropertyValue(resource, "maxLong"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Long.MAX_VALUE));
        Assert.assertThat(this.getPropertyValue(resource, "big"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigInteger(Long.toString(Long.MAX_VALUE)).add(BigInteger.ONE)));
        Assert.assertThat(this.getPropertyValue(resource, "bigger"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigInteger("100000000000000000000")));
        Assert.assertThat(this.getPropertyValue(resource, "fraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)12345.6789));
        Assert.assertThat(this.getPropertyValue(resource, "scientific1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)12300.0));
        Assert.assertThat(this.getPropertyValue(resource, "scientific2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0.00123));
        Assert.assertThat(this.getPropertyValue(resource, "scientific3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-1.234E7));
        Assert.assertThat(this.getPropertyValue(resource, "scientific4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-3.2145E-10));
        Assert.assertThat(this.getPropertyValue(resource, "scientific5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)4.567E90));
        Assert.assertThat(this.getPropertyValue(resource, "decimal"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("0.3")));
        Assert.assertThat(this.getPropertyValue(resource, "money"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.23")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalZero"), (Matcher)OptionalMatchers.isPresentAndIs((Object)BigDecimal.ZERO));
        Assert.assertThat(this.getPropertyValue(resource, "decimalZeroFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("0.0")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalOne"), (Matcher)OptionalMatchers.isPresentAndIs((Object)BigDecimal.ONE));
        Assert.assertThat(this.getPropertyValue(resource, "decimalOneFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.0")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalInteger"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("123")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalNegative"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("-123")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalLong"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("3456789123")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("12345.6789")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalScientific1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.23e+4")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalScientific2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("12.3e-4")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalScientific3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("-123.4e+5")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalScientific4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("-321.45e-12")));
        Assert.assertThat(this.getPropertyValue(resource, "decimalScientific5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("45.67e+89")));
    }

    @Test
    public void testOkRegularExpressions() throws IOException {
        Object resource = this.parseTestResource("ok-regular-expressions.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "empty").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)""));
        Assert.assertThat(this.getPropertyValue(resource, "abc").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"abc"));
        Assert.assertThat(this.getPropertyValue(resource, "regexEscape").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"ab\\.c"));
        Assert.assertThat(this.getPropertyValue(resource, "doubleBackslash").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\\\\"));
        Assert.assertThat(this.getPropertyValue(resource, "slash").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"/"));
    }

    @Test
    public void testOkStringFoobar() throws IOException {
        Optional<Object> object = this.parseTestResource("ok-string-foobar.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)"foobar"));
    }

    @Test
    public void testOkStrings() throws IOException {
        Object resource = this.parseTestResource("ok-strings.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "empty"), (Matcher)OptionalMatchers.isPresentAndIs((Object)""));
        Assert.assertThat(this.getPropertyValue(resource, "foo"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"bar"));
        Assert.assertThat(this.getPropertyValue(resource, "quote"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\""));
        Assert.assertThat(this.getPropertyValue(resource, "backslash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\\"));
        Assert.assertThat(this.getPropertyValue(resource, "solidus"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"/"));
        Assert.assertThat(this.getPropertyValue(resource, "ff"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\f"));
        Assert.assertThat(this.getPropertyValue(resource, "lf"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\n"));
        Assert.assertThat(this.getPropertyValue(resource, "cr"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\r"));
        Assert.assertThat(this.getPropertyValue(resource, "tab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\t"));
        Assert.assertThat(this.getPropertyValue(resource, "vtab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u000b"));
        Assert.assertThat(this.getPropertyValue(resource, "devanagari-ma"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u092e"));
        Assert.assertThat(this.getPropertyValue(resource, "devanagari-maEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u092e"));
        Assert.assertThat(this.getPropertyValue(resource, "tearsOfJoy"), (Matcher)OptionalMatchers.isPresentAndIs((Object)String.valueOf(Character.toChars(128514))));
        Assert.assertThat(this.getPropertyValue(resource, "tearsOfJoyEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)String.valueOf(Character.toChars(128514))));
    }

    @Test
    public void testOkTelephoneNumbers() throws IOException {
        Object resource = this.parseTestResource("ok-telephone-numbers.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "rfc3966Example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)TelephoneNumber.parse((CharSequence)"+12015550123")));
        Assert.assertThat(this.getPropertyValue(resource, "brazil"), (Matcher)OptionalMatchers.isPresentAndIs((Object)TelephoneNumber.parse((CharSequence)"+552187654321")));
    }

    @Test
    public void testOkTemporals() throws IOException {
        Object resource = this.parseTestResource("ok-temporals.surf").get();
        Assert.assertThat(this.getPropertyValue(resource, "instant"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Instant.parse("2017-02-12T23:29:18.829Z")));
        Assert.assertThat(this.getPropertyValue(resource, "zonedDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)ZonedDateTime.parse("2017-02-12T15:29:18.829-08:00[America/Los_Angeles]")));
        Assert.assertThat(this.getPropertyValue(resource, "offsetDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)OffsetDateTime.parse("2017-02-12T15:29:18.829-08:00")));
        Assert.assertThat(this.getPropertyValue(resource, "offsetTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)OffsetTime.parse("15:29:18.829-08:00")));
        Assert.assertThat(this.getPropertyValue(resource, "localDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalDateTime.parse("2017-02-12T15:29:18.829")));
        Assert.assertThat(this.getPropertyValue(resource, "localDate"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalDate.parse("2017-02-12")));
        Assert.assertThat(this.getPropertyValue(resource, "localTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalTime.parse("15:29:18.829")));
        Assert.assertThat(this.getPropertyValue(resource, "yearMonth"), (Matcher)OptionalMatchers.isPresentAndIs((Object)YearMonth.parse("2017-02")));
        Assert.assertThat(this.getPropertyValue(resource, "monthDay"), (Matcher)OptionalMatchers.isPresentAndIs((Object)MonthDay.parse("--02-12")));
        Assert.assertThat(this.getPropertyValue(resource, "year"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Year.parse("2017")));
    }

    @Test
    public void testOkUuid() throws IOException {
        Optional<Object> object = this.parseTestResource("ok-uuid.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)UUID.fromString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6")));
    }

    @Test
    public void testOkListEmpty() throws IOException {
        for (String okListEmptyResourceName : SurfTestResources.OK_LIST_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okListEmptyResourceName);
            Assert.assertThat((String)okListEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListEmptyResourceName, (Object)list, (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testOkListOneItem() throws IOException {
        for (String okListOneItemResourceName : SurfTestResources.OK_LIST_ONE_ITEM_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okListOneItemResourceName);
            Assert.assertThat((String)okListOneItemResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListOneItemResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListOneItemResourceName, (Object)list, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((String)okListOneItemResourceName, list.get(0), (Matcher)Matchers.is((Object)"one"));
        }
    }

    @Test
    public void testOkListTwoItems() throws IOException {
        for (String okListTwoItemsResourceName : SurfTestResources.OK_LIST_TWO_ITEMS_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okListTwoItemsResourceName);
            Assert.assertThat((String)okListTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListTwoItemsResourceName, (Object)list, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((String)okListTwoItemsResourceName, list.get(0), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okListTwoItemsResourceName, list.get(1), (Matcher)Matchers.is((Object)"two"));
        }
    }

    @Test
    public void testOkMaps() throws IOException {
        Optional<Object> object = this.parseTestResource("ok-maps.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
        Map map = (Map)object.get();
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat(map.get("foo"), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat(map.get(123L), (Matcher)Matchers.is((Object)"number"));
        Assert.assertThat(map.get(false), (Matcher)Matchers.is((Object)"Boolean"));
        Assert.assertThat(map.get(true), (Matcher)Matchers.is((Object)"Boolean"));
        Assert.assertThat(map.get(Arrays.asList(1L, 2L, 3L)), (Matcher)Matchers.is((Object)new BigDecimal("1.23")));
        HashMap<String, List<CodePointCharacter>> pingPong = new HashMap<String, List<CodePointCharacter>>();
        pingPong.put("ping", Arrays.asList(CodePointCharacter.of((char)'p'), CodePointCharacter.of((char)'o'), CodePointCharacter.of((char)'n'), CodePointCharacter.of((char)'g')));
        Assert.assertThat(map.get("map"), (Matcher)Matchers.is(pingPong));
        Assert.assertThat(map.get(new HashSet<Serializable>(Arrays.asList("foo", false))), (Matcher)Matchers.is((Object)true));
        HashMap<String, String> abbrMap = new HashMap<String, String>();
        abbrMap.put("ITTF", "International Table Tennis Federation");
        Assert.assertThat(map.get(abbrMap), (Matcher)Matchers.is((Object)"abbr"));
    }

    @Test
    public void testOkMapEmpty() throws IOException {
        for (String okMapEmptyResourceName : SurfTestResources.OK_MAP_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okMapEmptyResourceName);
            Assert.assertThat((String)okMapEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkMapOneEntry() throws IOException {
        for (String okMapOneEntryResourceName : SurfTestResources.OK_MAP_ONE_ENTRY_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okMapOneEntryResourceName);
            Assert.assertThat((String)okMapOneEntryResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapOneEntryResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((String)okMapOneEntryResourceName, (Object)map.containsKey("I"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapOneEntryResourceName, map.get("I"), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okMapOneEntryResourceName, (Object)map.containsKey("II"), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testOkMapTwoEntries() throws IOException {
        for (String okMapTwoEntriesResourceName : SurfTestResources.OK_MAP_TWO_ENTRIES_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okMapTwoEntriesResourceName);
            Assert.assertThat((String)okMapTwoEntriesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapTwoEntriesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("I"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapTwoEntriesResourceName, map.get("I"), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("II"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapTwoEntriesResourceName, map.get("II"), (Matcher)Matchers.is((Object)"two"));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("III"), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testOkSetEmpty() throws IOException {
        for (String okSetEmptyResourceName : SurfTestResources.OK_SET_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okSetEmptyResourceName);
            Assert.assertThat((String)okSetEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetEmptyResourceName, (Object)set, (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testOkSetOneItem() throws IOException {
        for (String okSetOneItemResourceName : SurfTestResources.OK_SET_ONE_ITEM_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okSetOneItemResourceName);
            Assert.assertThat((String)okSetOneItemResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetOneItemResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetOneItemResourceName, (Object)set, (Matcher)Matchers.equalTo(new HashSet<String>(Arrays.asList("one"))));
        }
    }

    @Test
    public void testOkSetTwoItems() throws IOException {
        for (String okSetTwoItemsResourceName : SurfTestResources.OK_SET_TWO_ITEMS_RESOURCE_NAMES) {
            Optional<Object> object = this.parseTestResource(okSetTwoItemsResourceName);
            Assert.assertThat((String)okSetTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetTwoItemsResourceName, (Object)set, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((String)okSetTwoItemsResourceName, (Object)set, (Matcher)Matchers.equalTo(new HashSet<String>(Arrays.asList("one", "two"))));
        }
    }
}

