/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import io.urf.surf.AbstractSimpleGraphSurfParserTest;
import io.urf.surf.SurfObject;
import io.urf.surf.SurfParser;
import io.urf.surf.SurfTestResources;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SurfParserTest
extends AbstractSimpleGraphSurfParserTest<SurfObject> {
    @Override
    protected Optional<Object> parseTestResource(@Nonnull InputStream inputStream) throws IOException {
        return new SurfParser().parse(inputStream);
    }

    @Override
    protected Class<SurfObject> getSurfObjectClass() {
        return SurfObject.class;
    }

    @Override
    public Optional<String> getTypeHandle(SurfObject surfObject) {
        return surfObject.getTypeHandle();
    }

    @Override
    protected int getPropertyCount(SurfObject surfObject) {
        return surfObject.getPropertyCount();
    }

    @Override
    public Optional<Object> getPropertyValue(SurfObject surfObject, String propertyHandle) {
        return surfObject.getPropertyValue(propertyHandle);
    }

    @Test
    public void testOkLabels() throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream("ok-labels.surf");){
            SurfParser surfParser = new SurfParser();
            SurfObject root = (SurfObject)surfParser.parse(inputStream).get();
            Optional rootAliased = surfParser.findResourceByAlias("root");
            Assert.assertThat((Object)rootAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)root)));
            Object foo = root.getPropertyValue("foo").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(foo, (Matcher)Matchers.is((Object)123L));
            Optional numberAliased = surfParser.findResourceByAlias("number");
            Assert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(foo)));
            Object value = root.getPropertyValue("value").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(value, (Matcher)Matchers.is((Object)false));
            Optional testAliased = surfParser.findResourceByAlias("test");
            Assert.assertThat((Object)testAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(value)));
            SurfObject thing = (SurfObject)root.getPropertyValue("thing").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)thing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Type"));
            Optional objectAliased = surfParser.findResourceByAlias("object");
            Assert.assertThat((Object)objectAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)thing)));
            SurfObject foobar = (SurfObject)root.getPropertyValue("foobar").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)foobar.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Bar"));
            Assert.assertThat((Object)foobar.getId(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foo"));
            Assert.assertThat((Object)foobar.getPropertyValue("prop"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"val"));
            Optional foobarIded = surfParser.findObjectById("Bar", "foo");
            Assert.assertThat((Object)foobarIded, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)foobar)));
            List stuff = (List)thing.getPropertyValue("stuff").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)stuff, (Matcher)Matchers.hasSize((int)4));
            Assert.assertThat(stuff.get(0), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat(stuff.get(1), (Matcher)Matchers.is((Object)123L));
            Assert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(stuff.get(1))));
            Assert.assertThat(stuff.get(2), (Matcher)Matchers.is((Object)"three"));
            Object stuffElement4 = stuff.get(3);
            Assert.assertThat(stuffElement4, (Matcher)Matchers.instanceOf(this.getSurfObjectClass()));
            SurfObject exampleThing = (SurfObject)stuffElement4;
            Assert.assertThat((Object)exampleThing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            Assert.assertThat((Object)exampleThing.getTag(), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://example.com/thing")));
            Assert.assertThat((Object)exampleThing.getPropertyValue("name"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Example Thing"));
            Optional exampleThingTagged = surfParser.findObjectByTag(URI.create("http://example.com/thing"));
            Assert.assertThat((Object)exampleThingTagged, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)exampleThing)));
            Map map = (Map)root.getPropertyValue("map").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(map.get(1L), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat(map.get(2L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(numberAliased.get())));
            Assert.assertThat(map.get(4L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)foobar)));
            Assert.assertThat(map.get(99L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(exampleThingTagged.get())));
            Assert.assertThat(map.get(100L), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(objectAliased.get())));
            Set set = (Set)root.getPropertyValue("set").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)set, (Matcher)Matchers.hasSize((int)5));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)123L));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)false));
            Optional newAliased = surfParser.findResourceByAlias("newThing");
            SurfObject newAliasedResource = (SurfObject)newAliased.orElseThrow(AssertionFailedError::new);
            Assert.assertThat(this.getTypeHandle(newAliasedResource), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            Assert.assertThat(this.getPropertyValue(newAliasedResource, "description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"a new thing"));
            Optional anotherAliased = surfParser.findResourceByAlias("another");
            SurfObject anotherAliasedResource = (SurfObject)anotherAliased.orElseThrow(AssertionFailedError::new);
            Assert.assertThat(this.getPropertyValue(anotherAliasedResource, "description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"yet another thing"));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(numberAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(testAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(objectAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)newAliasedResource)));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)anotherAliasedResource)));
        }
    }
}

