/*
 * Decompiled with CFR 0.152.
 */
package io.urf.surf;

import com.github.npathai.hamcrestopt.OptionalMatchers;
import com.globalmentor.itu.TelephoneNumber;
import com.globalmentor.java.Bytes;
import com.globalmentor.java.CodePointCharacter;
import com.globalmentor.net.EmailAddress;
import io.urf.surf.SurfObject;
import io.urf.surf.SurfParser;
import io.urf.surf.SurfTestResources;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SurfParserTest {
    protected static Optional<Object> parseTestResource(@Nonnull String testResourceName) throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream(testResourceName);){
            Optional optional = new SurfParser().parse(inputStream);
            return optional;
        }
    }

    @Test
    public void testOkSimpleResources() throws IOException {
        for (String okSimpleResourceName : SurfTestResources.OK_SIMPLE_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okSimpleResourceName);
            Assert.assertThat((String)okSimpleResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSimpleResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(SurfObject.class)));
            SurfObject resource = (SurfObject)object.get();
            Assert.assertThat((String)okSimpleResourceName, (Object)resource.getTypeHandle(), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okSimpleResourceName, (Object)resource.getPropertyCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkObjectNoProperties() throws IOException {
        for (String okObjectNoPropertiesResourceName : SurfTestResources.OK_OBJECT_NO_PROPERTIES_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okObjectNoPropertiesResourceName);
            Assert.assertThat((String)okObjectNoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectNoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(SurfObject.class)));
            SurfObject resource = (SurfObject)object.get();
            Assert.assertThat((String)okObjectNoPropertiesResourceName, (Object)resource.getTypeHandle(), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectNoPropertiesResourceName, (Object)resource.getPropertyCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkObjectOneProperty() throws IOException {
        for (String okObjectOnePropertyResourceName : SurfTestResources.OK_OBJECT_ONE_PROPERTY_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okObjectOnePropertyResourceName);
            Assert.assertThat((String)okObjectOnePropertyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectOnePropertyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(SurfObject.class)));
            SurfObject resource = (SurfObject)object.get();
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)resource.getTypeHandle(), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)resource.getPropertyCount(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)resource.getPropertyValue("one"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)resource.getPropertyValue("one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"one"));
            Assert.assertThat((String)okObjectOnePropertyResourceName, (Object)resource.getPropertyValue("two"), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
        }
    }

    @Test
    public void testOkObjectTwoProperties() throws IOException {
        for (String okObjectTwoPropertiesResourceName : SurfTestResources.OK_OBJECT_TWO_PROPERTIES_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okObjectTwoPropertiesResourceName);
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(SurfObject.class)));
            SurfObject resource = (SurfObject)object.get();
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getTypeHandle(), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyCount(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyValue("one"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyValue("one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"one"));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyValue("two"), (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyValue("two"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"two"));
            Assert.assertThat((String)okObjectTwoPropertiesResourceName, (Object)resource.getPropertyValue("three"), (Matcher)Matchers.not((Matcher)OptionalMatchers.isPresent()));
        }
    }

    @Test
    public void testOkObjectType() throws IOException {
        for (String okObjectTypeResourceName : SurfTestResources.OK_OBJECT_TYPE_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okObjectTypeResourceName);
            Assert.assertThat((String)okObjectTypeResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okObjectTypeResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(SurfObject.class)));
            SurfObject resource = (SurfObject)object.get();
            Assert.assertThat((String)okObjectTypeResourceName, (Object)resource.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-FooBar"));
            Assert.assertThat((String)okObjectTypeResourceName, (Object)resource.getPropertyCount(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkBinary() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-binary.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("count"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648Example1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3, -39, 126}));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648Example2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3, -39}));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648Example3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new byte[]{20, -5, -100, 3}));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Bytes.NO_BYTES));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"f".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"fo".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foo".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foob".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector6"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"fooba".getBytes(StandardCharsets.US_ASCII)));
        Assert.assertThat((Object)resource.getPropertyValue("rfc4648TestVector7"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foobar".getBytes(StandardCharsets.US_ASCII)));
    }

    @Test
    public void testOkBooleanFalse() throws IOException {
        Optional<Object> object = SurfParserTest.parseTestResource("ok-boolean-false.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)Boolean.FALSE));
    }

    @Test
    public void testOkBooleanTrue() throws IOException {
        Optional<Object> object = SurfParserTest.parseTestResource("ok-boolean-true.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)Boolean.TRUE));
    }

    @Test
    public void testOkCharacters() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-characters.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("foo"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'|')));
        Assert.assertThat((Object)resource.getPropertyValue("quote"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\"')));
        Assert.assertThat((Object)resource.getPropertyValue("apostrophe"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\'')));
        Assert.assertThat((Object)resource.getPropertyValue("backslash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\\')));
        Assert.assertThat((Object)resource.getPropertyValue("solidus"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'/')));
        Assert.assertThat((Object)resource.getPropertyValue("backspace"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\b')));
        Assert.assertThat((Object)resource.getPropertyValue("ff"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\f')));
        Assert.assertThat((Object)resource.getPropertyValue("lf"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\n')));
        Assert.assertThat((Object)resource.getPropertyValue("cr"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\r')));
        Assert.assertThat((Object)resource.getPropertyValue("tab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\t')));
        Assert.assertThat((Object)resource.getPropertyValue("vtab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u000b')));
        Assert.assertThat((Object)resource.getPropertyValue("devanagari-ma"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u092e')));
        Assert.assertThat((Object)resource.getPropertyValue("devanagari-maEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((char)'\u092e')));
        Assert.assertThat((Object)resource.getPropertyValue("tearsOfJoy"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((int)128514)));
        Assert.assertThat((Object)resource.getPropertyValue("tearsOfJoyEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)CodePointCharacter.of((int)128514)));
    }

    @Test
    public void testOkEmailAddresses() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-email-addresses.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jdoe@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("dot"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("tag"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe+tag@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("dash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"jane.doe-foo@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("x"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"x@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("dashedDomain"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"foo-bar@strange-example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("longTLD"), (Matcher)OptionalMatchers.isPresentAndIs((Object)EmailAddress.fromString((String)"example@s.solutions")));
    }

    @Test
    public void testOkIris() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-iris.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://www.example.com/")));
        Assert.assertThat((Object)resource.getPropertyValue("iso_8859_1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://www.example.org/D\u00fcrst")));
        Assert.assertThat((Object)resource.getPropertyValue("encodedForbidden"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://xn--99zt52a.example.org/%E2%80%AE")));
        Assert.assertThat((Object)resource.getPropertyValue("encodedForbidden"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://xn--99zt52a.example.org/%E2%80%AE")));
        Assert.assertThat((Object)resource.getPropertyValue("mailto"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("mailto:jdoe@example.com")));
        Assert.assertThat((Object)resource.getPropertyValue("tel"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("tel:+12015550123")));
        Assert.assertThat((Object)resource.getPropertyValue("urn_uuid"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("urn:uuid:5623962b-22b1-4680-ae1c-7174a46144fc")));
        Assert.assertThat((Object)resource.getPropertyValue("isbn"), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("urn:isbn:0-395-36341-1")));
    }

    @Test
    public void testOkNumbers() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-numbers.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("zero"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0));
        Assert.assertThat((Object)resource.getPropertyValue("zeroFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0.0));
        Assert.assertThat((Object)resource.getPropertyValue("one"), (Matcher)OptionalMatchers.isPresentAndIs((Object)1));
        Assert.assertThat((Object)resource.getPropertyValue("oneFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)1.0));
        Assert.assertThat((Object)resource.getPropertyValue("integer"), (Matcher)OptionalMatchers.isPresentAndIs((Object)123));
        Assert.assertThat((Object)resource.getPropertyValue("negative"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-123));
        Assert.assertThat((Object)resource.getPropertyValue("long"), (Matcher)OptionalMatchers.isPresentAndIs((Object)3456789123L));
        Assert.assertThat((Object)resource.getPropertyValue("fraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)12345.6789));
        Assert.assertThat((Object)resource.getPropertyValue("scientific1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)12300.0));
        Assert.assertThat((Object)resource.getPropertyValue("scientific2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0.00123));
        Assert.assertThat((Object)resource.getPropertyValue("scientific3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-1.234E7));
        Assert.assertThat((Object)resource.getPropertyValue("scientific4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)-3.2145E-10));
        Assert.assertThat((Object)resource.getPropertyValue("scientific5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)4.567E90));
        Assert.assertThat((Object)resource.getPropertyValue("decimal"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("0.3")));
        Assert.assertThat((Object)resource.getPropertyValue("money"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.23")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalZero"), (Matcher)OptionalMatchers.isPresentAndIs((Object)BigInteger.ZERO));
        Assert.assertThat((Object)resource.getPropertyValue("decimalZeroFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("0.0")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalOne"), (Matcher)OptionalMatchers.isPresentAndIs((Object)BigInteger.ONE));
        Assert.assertThat((Object)resource.getPropertyValue("decimalOneFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.0")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalInteger"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigInteger("123")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalNegative"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigInteger("-123")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalLong"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigInteger("3456789123")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalFraction"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("12345.6789")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalScientific1"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("1.23e+4")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalScientific2"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("12.3e-4")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalScientific3"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("-123.4e+5")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalScientific4"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("-321.45e-12")));
        Assert.assertThat((Object)resource.getPropertyValue("decimalScientific5"), (Matcher)OptionalMatchers.isPresentAndIs((Object)new BigDecimal("45.67e+89")));
    }

    @Test
    public void testOkRegularExpressions() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-regular-expressions.surf").get();
        Assert.assertThat(resource.getPropertyValue("empty").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)""));
        Assert.assertThat(resource.getPropertyValue("abc").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"abc"));
        Assert.assertThat(resource.getPropertyValue("regexEscape").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"ab\\.c"));
        Assert.assertThat(resource.getPropertyValue("doubleBackslash").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\\\\"));
        Assert.assertThat(resource.getPropertyValue("slash").map(Pattern.class::cast).map(Pattern::pattern), (Matcher)OptionalMatchers.isPresentAndIs((Object)"/"));
    }

    @Test
    public void testOkStringFoobar() throws IOException {
        Optional<Object> object = SurfParserTest.parseTestResource("ok-string-foobar.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)"foobar"));
    }

    @Test
    public void testOkStrings() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-strings.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("empty"), (Matcher)OptionalMatchers.isPresentAndIs((Object)""));
        Assert.assertThat((Object)resource.getPropertyValue("foo"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"bar"));
        Assert.assertThat((Object)resource.getPropertyValue("quote"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\""));
        Assert.assertThat((Object)resource.getPropertyValue("backslash"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\\"));
        Assert.assertThat((Object)resource.getPropertyValue("solidus"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"/"));
        Assert.assertThat((Object)resource.getPropertyValue("ff"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\f"));
        Assert.assertThat((Object)resource.getPropertyValue("lf"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\n"));
        Assert.assertThat((Object)resource.getPropertyValue("cr"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\r"));
        Assert.assertThat((Object)resource.getPropertyValue("tab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\t"));
        Assert.assertThat((Object)resource.getPropertyValue("vtab"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u000b"));
        Assert.assertThat((Object)resource.getPropertyValue("devanagari-ma"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u092e"));
        Assert.assertThat((Object)resource.getPropertyValue("devanagari-maEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"\u092e"));
        Assert.assertThat((Object)resource.getPropertyValue("tearsOfJoy"), (Matcher)OptionalMatchers.isPresentAndIs((Object)String.valueOf(Character.toChars(128514))));
        Assert.assertThat((Object)resource.getPropertyValue("tearsOfJoyEscaped"), (Matcher)OptionalMatchers.isPresentAndIs((Object)String.valueOf(Character.toChars(128514))));
    }

    @Test
    public void testOkTelephoneNumbers() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-telephone-numbers.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("rfc3966Example"), (Matcher)OptionalMatchers.isPresentAndIs((Object)TelephoneNumber.parse((CharSequence)"+12015550123")));
        Assert.assertThat((Object)resource.getPropertyValue("brazil"), (Matcher)OptionalMatchers.isPresentAndIs((Object)TelephoneNumber.parse((CharSequence)"+552187654321")));
    }

    @Test
    public void testOkTemporals() throws IOException {
        SurfObject resource = (SurfObject)SurfParserTest.parseTestResource("ok-temporals.surf").get();
        Assert.assertThat((Object)resource.getPropertyValue("instant"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Instant.parse("2017-02-12T23:29:18.829Z")));
        Assert.assertThat((Object)resource.getPropertyValue("zonedDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)ZonedDateTime.parse("2017-02-12T15:29:18.829-08:00[America/Los_Angeles]")));
        Assert.assertThat((Object)resource.getPropertyValue("offsetDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)OffsetDateTime.parse("2017-02-12T15:29:18.829-08:00")));
        Assert.assertThat((Object)resource.getPropertyValue("offsetTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)OffsetTime.parse("15:29:18.829-08:00")));
        Assert.assertThat((Object)resource.getPropertyValue("localDateTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalDateTime.parse("2017-02-12T15:29:18.829")));
        Assert.assertThat((Object)resource.getPropertyValue("localDate"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalDate.parse("2017-02-12")));
        Assert.assertThat((Object)resource.getPropertyValue("localTime"), (Matcher)OptionalMatchers.isPresentAndIs((Object)LocalTime.parse("15:29:18.829")));
        Assert.assertThat((Object)resource.getPropertyValue("yearMonth"), (Matcher)OptionalMatchers.isPresentAndIs((Object)YearMonth.parse("2017-02")));
        Assert.assertThat((Object)resource.getPropertyValue("monthDay"), (Matcher)OptionalMatchers.isPresentAndIs((Object)MonthDay.parse("--02-12")));
        Assert.assertThat((Object)resource.getPropertyValue("year"), (Matcher)OptionalMatchers.isPresentAndIs((Object)Year.parse("2017")));
    }

    @Test
    public void testOkUuid() throws IOException {
        Optional<Object> object = SurfParserTest.parseTestResource("ok-uuid.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAndIs((Object)UUID.fromString("f81d4fae-7dec-11d0-a765-00a0c91e6bf6")));
    }

    @Test
    public void testOkListEmpty() throws IOException {
        for (String okListEmptyResourceName : SurfTestResources.OK_LIST_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okListEmptyResourceName);
            Assert.assertThat((String)okListEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListEmptyResourceName, (Object)list, (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testOkListOneItem() throws IOException {
        for (String okListOneItemResourceName : SurfTestResources.OK_LIST_ONE_ITEM_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okListOneItemResourceName);
            Assert.assertThat((String)okListOneItemResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListOneItemResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListOneItemResourceName, (Object)list, (Matcher)Matchers.hasSize((int)1));
            Assert.assertThat((String)okListOneItemResourceName, list.get(0), (Matcher)Matchers.is((Object)"one"));
        }
    }

    @Test
    public void testOkListTwoItems() throws IOException {
        for (String okListTwoItemsResourceName : SurfTestResources.OK_LIST_TWO_ITEMS_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okListTwoItemsResourceName);
            Assert.assertThat((String)okListTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okListTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(List.class)));
            List list = (List)object.get();
            Assert.assertThat((String)okListTwoItemsResourceName, (Object)list, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((String)okListTwoItemsResourceName, list.get(0), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okListTwoItemsResourceName, list.get(1), (Matcher)Matchers.is((Object)"two"));
        }
    }

    @Test
    public void testOkMaps() throws IOException {
        Optional<Object> object = SurfParserTest.parseTestResource("ok-maps.surf");
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresent());
        Assert.assertThat(object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
        Map map = (Map)object.get();
        Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)10));
        Assert.assertThat(map.get("foo"), (Matcher)Matchers.is((Object)"bar"));
        Assert.assertThat(map.get(123), (Matcher)Matchers.is((Object)"number"));
        Assert.assertThat(map.get(false), (Matcher)Matchers.is((Object)"Boolean"));
        Assert.assertThat(map.get(true), (Matcher)Matchers.is((Object)"Boolean"));
        Assert.assertThat(map.get(Arrays.asList(1, 2, 3)), (Matcher)Matchers.is((Object)new BigDecimal("1.23")));
        HashMap<String, List<CodePointCharacter>> pingPong = new HashMap<String, List<CodePointCharacter>>();
        pingPong.put("ping", Arrays.asList(CodePointCharacter.of((char)'p'), CodePointCharacter.of((char)'o'), CodePointCharacter.of((char)'n'), CodePointCharacter.of((char)'g')));
        Assert.assertThat(map.get("map"), (Matcher)Matchers.is(pingPong));
        Assert.assertThat(map.get(new HashSet<Serializable>(Arrays.asList("foo", false))), (Matcher)Matchers.is((Object)true));
        Assert.assertThat(map.get(new SurfObject("Game", "pingpong")), (Matcher)Matchers.is((Object)"ping pong"));
        SurfObject bullsEye = null;
        for (Map.Entry entry : map.entrySet()) {
            if (!entry.getValue().equals("Bull's Eye")) continue;
            Assert.assertThat(entry.getKey(), (Matcher)Matchers.instanceOf(SurfObject.class));
            bullsEye = (SurfObject)entry.getKey();
            break;
        }
        Assert.assertThat((Object)bullsEye.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Point"));
        Assert.assertThat((Object)bullsEye.getPropertyValue("x"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0));
        Assert.assertThat((Object)bullsEye.getPropertyValue("y"), (Matcher)OptionalMatchers.isPresentAndIs((Object)0));
        HashMap<String, String> abbrMap = new HashMap<String, String>();
        abbrMap.put("ITTF", "International Table Tennis Federation");
        Assert.assertThat(map.get(abbrMap), (Matcher)Matchers.is((Object)"abbr"));
    }

    @Test
    public void testOkMapEmpty() throws IOException {
        for (String okMapEmptyResourceName : SurfTestResources.OK_MAP_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okMapEmptyResourceName);
            Assert.assertThat((String)okMapEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testOkMapOneEntry() throws IOException {
        for (String okMapOneEntryResourceName : SurfTestResources.OK_MAP_ONE_ENTRY_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okMapOneEntryResourceName);
            Assert.assertThat((String)okMapOneEntryResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapOneEntryResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)1));
            Assert.assertThat((String)okMapOneEntryResourceName, (Object)map.containsKey("I"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapOneEntryResourceName, map.get("I"), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okMapOneEntryResourceName, (Object)map.containsKey("II"), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testOkMapTwoEntries() throws IOException {
        for (String okMapTwoEntriesResourceName : SurfTestResources.OK_MAP_TWO_ENTRIES_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okMapTwoEntriesResourceName);
            Assert.assertThat((String)okMapTwoEntriesResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okMapTwoEntriesResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Map.class)));
            Map map = (Map)object.get();
            Assert.assertThat((Object)map.size(), (Matcher)Matchers.is((Object)2));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("I"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapTwoEntriesResourceName, map.get("I"), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("II"), (Matcher)Matchers.is((Object)true));
            Assert.assertThat((String)okMapTwoEntriesResourceName, map.get("II"), (Matcher)Matchers.is((Object)"two"));
            Assert.assertThat((String)okMapTwoEntriesResourceName, (Object)map.containsKey("III"), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void testOkSetEmpty() throws IOException {
        for (String okSetEmptyResourceName : SurfTestResources.OK_SET_EMPTY_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okSetEmptyResourceName);
            Assert.assertThat((String)okSetEmptyResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetEmptyResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetEmptyResourceName, (Object)set, (Matcher)Matchers.hasSize((int)0));
        }
    }

    @Test
    public void testOkSetOneItem() throws IOException {
        for (String okSetOneItemResourceName : SurfTestResources.OK_SET_ONE_ITEM_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okSetOneItemResourceName);
            Assert.assertThat((String)okSetOneItemResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetOneItemResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetOneItemResourceName, (Object)set, (Matcher)Matchers.equalTo(new HashSet<String>(Arrays.asList("one"))));
        }
    }

    @Test
    public void testOkSetTwoItems() throws IOException {
        for (String okSetTwoItemsResourceName : SurfTestResources.OK_SET_TWO_ITEMS_RESOURCE_NAMES) {
            Optional<Object> object = SurfParserTest.parseTestResource(okSetTwoItemsResourceName);
            Assert.assertThat((String)okSetTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresent());
            Assert.assertThat((String)okSetTwoItemsResourceName, object, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.instanceOf(Set.class)));
            Set set = (Set)object.get();
            Assert.assertThat((String)okSetTwoItemsResourceName, (Object)set, (Matcher)Matchers.hasSize((int)2));
            Assert.assertThat((String)okSetTwoItemsResourceName, (Object)set, (Matcher)Matchers.equalTo(new HashSet<String>(Arrays.asList("one", "two"))));
        }
    }

    @Test
    public void testOkLabels() throws IOException {
        try (InputStream inputStream = SurfTestResources.class.getResourceAsStream("ok-labels.surf");){
            SurfParser surfParser = new SurfParser();
            SurfObject root = (SurfObject)surfParser.parse(inputStream).get();
            Optional rootAliased = surfParser.findResourceByAlias("root");
            Assert.assertThat((Object)rootAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)root)));
            Object foo = root.getPropertyValue("foo").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(foo, (Matcher)Matchers.is((Object)123));
            Optional numberAliased = surfParser.findResourceByAlias("number");
            Assert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(foo)));
            Object value = root.getPropertyValue("value").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(value, (Matcher)Matchers.is((Object)false));
            Optional testAliased = surfParser.findResourceByAlias("test");
            Assert.assertThat((Object)testAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(value)));
            SurfObject thing = (SurfObject)root.getPropertyValue("thing").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)thing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Type"));
            Optional objectAliased = surfParser.findResourceByAlias("object");
            Assert.assertThat((Object)objectAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)thing)));
            SurfObject foobar = (SurfObject)root.getPropertyValue("foobar").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)foobar.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Bar"));
            Assert.assertThat((Object)foobar.getId(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"foo"));
            Assert.assertThat((Object)foobar.getPropertyValue("prop"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"val"));
            Optional foobarIded = surfParser.findObjectById("Bar", "foo");
            Assert.assertThat((Object)foobarIded, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)foobar)));
            List stuff = (List)thing.getPropertyValue("stuff").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)stuff, (Matcher)Matchers.hasSize((int)4));
            Assert.assertThat(stuff.get(0), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat(stuff.get(1), (Matcher)Matchers.is((Object)123));
            Assert.assertThat((Object)numberAliased, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance(stuff.get(1))));
            Assert.assertThat(stuff.get(2), (Matcher)Matchers.is((Object)"three"));
            Object stuffElement4 = stuff.get(3);
            Assert.assertThat(stuffElement4, (Matcher)Matchers.instanceOf(SurfObject.class));
            SurfObject exampleThing = (SurfObject)stuffElement4;
            Assert.assertThat((Object)exampleThing.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            Assert.assertThat((Object)exampleThing.getTag(), (Matcher)OptionalMatchers.isPresentAndIs((Object)URI.create("http://example.com/thing")));
            Assert.assertThat((Object)exampleThing.getPropertyValue("name"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"Example Thing"));
            Optional exampleThingTagged = surfParser.findObjectByTag(URI.create("http://example.com/thing"));
            Assert.assertThat((Object)exampleThingTagged, (Matcher)OptionalMatchers.isPresentAnd((Matcher)Matchers.sameInstance((Object)exampleThing)));
            Map map = (Map)root.getPropertyValue("map").orElseThrow(AssertionFailedError::new);
            Assert.assertThat(map.get(1), (Matcher)Matchers.is((Object)"one"));
            Assert.assertThat(map.get(2), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(numberAliased.get())));
            Assert.assertThat(map.get(4), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)foobar)));
            Assert.assertThat(map.get(99), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(exampleThingTagged.get())));
            Assert.assertThat(map.get(100), (Matcher)Matchers.is((Matcher)Matchers.sameInstance(objectAliased.get())));
            Set set = (Set)root.getPropertyValue("set").orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)set, (Matcher)Matchers.hasSize((int)5));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)123));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Object)false));
            Optional newAliased = surfParser.findResourceByAlias("newThing");
            SurfObject newAliasedResource = (SurfObject)newAliased.orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)newAliasedResource.getTypeHandle(), (Matcher)OptionalMatchers.isPresentAndIs((Object)"example-Thing"));
            Assert.assertThat((Object)newAliasedResource.getPropertyValue("description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"a new thing"));
            Optional anotherAliased = surfParser.findResourceByAlias("another");
            SurfObject anotherAliasedResource = (SurfObject)anotherAliased.orElseThrow(AssertionFailedError::new);
            Assert.assertThat((Object)anotherAliasedResource.getPropertyValue("description"), (Matcher)OptionalMatchers.isPresentAndIs((Object)"yet another thing"));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(numberAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(testAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance(objectAliased.get())));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)newAliasedResource)));
            Assert.assertThat((Object)set, (Matcher)Matchers.hasItem((Matcher)Matchers.sameInstance((Object)anotherAliasedResource)));
        }
    }
}

