/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.annotationprocessor;

import io.undertow.annotationprocessor.HttpParserConfig;
import io.undertow.annotationprocessor.HttpResponseParserConfig;
import io.undertow.annotationprocessor.RequestParserGenerator;
import io.undertow.annotationprocessor.ResponseParserGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.undertow.annotationprocessor.HttpParserConfig"})
@SupportedOptions(value={})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class HttpParserAnnotationProcessor
extends AbstractProcessor {
    private Filer filer;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        OutputStream out;
        JavaFileObject file;
        byte[] newClass;
        for (Element element : roundEnv.getElementsAnnotatedWith(HttpParserConfig.class)) {
            HttpParserConfig parser = element.getAnnotation(HttpParserConfig.class);
            if (parser == null) continue;
            RequestParserGenerator requestGenerator = new RequestParserGenerator(((TypeElement)element).getQualifiedName().toString());
            newClass = requestGenerator.createTokenizer(parser.methods(), parser.protocols(), parser.headers());
            try {
                file = this.filer.createClassFile(String.valueOf(((TypeElement)element).getQualifiedName()) + "$$generated", element);
                out = file.openOutputStream();
                try {
                    out.write(newClass);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(HttpResponseParserConfig.class)) {
            ResponseParserGenerator responseGenerator = new ResponseParserGenerator(((TypeElement)element).getQualifiedName().toString());
            HttpResponseParserConfig parser = element.getAnnotation(HttpResponseParserConfig.class);
            if (parser == null) continue;
            newClass = responseGenerator.createTokenizer(new String[0], parser.protocols(), parser.headers());
            try {
                file = this.filer.createClassFile(String.valueOf(((TypeElement)element).getQualifiedName()) + "$$generated", element);
                out = file.openOutputStream();
                try {
                    out.write(newClass);
                }
                finally {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

