/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.server.Connectors;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.MalformedMessageException;
import io.undertow.util.MultipartParser;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.xnio.FileAccess;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSourceChannel;

public class MultiPartParserDefinition
implements FormParserFactory.ParserDefinition {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private Executor executor;
    private File tempFileLocation;
    private String defaultEncoding = "ISO-8859-1";
    private long maxIndividualFileSize = -1L;

    public MultiPartParserDefinition() {
        this.tempFileLocation = new File(System.getProperty("java.io.tmpdir"));
    }

    public MultiPartParserDefinition(File tempDir) {
        this.tempFileLocation = tempDir;
    }

    @Override
    public FormDataParser create(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = Headers.extractTokenFromHeader(mimeType, "boundary");
            if (boundary == null) {
                UndertowLogger.REQUEST_LOGGER.debugf("Could not find boundary in multipart request with ContentType: %s, multipart data will not be available", mimeType);
                return null;
            }
            final MultiPartUploadHandler parser = new MultiPartUploadHandler(exchange, boundary, this.maxIndividualFileSize, this.defaultEncoding);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
                    IoUtils.safeClose((Closeable)parser);
                    nextListener.proceed();
                }
            });
            return parser;
        }
        return null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MultiPartParserDefinition setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public File getTempFileLocation() {
        return this.tempFileLocation;
    }

    public MultiPartParserDefinition setTempFileLocation(File tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
        return this;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public MultiPartParserDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public long getMaxIndividualFileSize() {
        return this.maxIndividualFileSize;
    }

    public void setMaxIndividualFileSize(long maxIndividualFileSize) {
        this.maxIndividualFileSize = maxIndividualFileSize;
    }

    private final class MultiPartUploadHandler
    implements FormDataParser,
    Runnable,
    MultipartParser.PartHandler {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final String boundary;
        private final List<File> createdFiles = new ArrayList<File>();
        private final long maxIndividualFileSize;
        private String defaultEncoding;
        private final ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
        private String currentName;
        private String fileName;
        private File file;
        private FileChannel fileChannel;
        private HeaderMap headers;
        private HttpHandler handler;
        private long currentFileSize;

        private MultiPartUploadHandler(HttpServerExchange exchange, String boundary, long maxIndividualFileSize, String defaultEncoding) {
            this.exchange = exchange;
            this.boundary = boundary;
            this.maxIndividualFileSize = maxIndividualFileSize;
            this.defaultEncoding = defaultEncoding;
            this.data = new FormData(exchange.getConnection().getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, 1000));
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            if (MultiPartParserDefinition.this.executor == null) {
                this.exchange.dispatch(this);
            } else {
                this.exchange.dispatch(MultiPartParserDefinition.this.executor, this);
            }
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            MultipartParser.ParseState parser = MultipartParser.beginParse(this.exchange.getConnection().getBufferPool(), this, this.boundary.getBytes());
            Pooled resource = this.exchange.getConnection().getBufferPool().allocate();
            StreamSourceChannel requestChannel = this.exchange.getRequestChannel();
            if (requestChannel == null) {
                throw new IOException(UndertowMessages.MESSAGES.requestChannelAlreadyProvided());
            }
            ByteBuffer buf = (ByteBuffer)resource.getResource();
            try {
                while (!parser.isComplete()) {
                    buf.clear();
                    requestChannel.awaitReadable();
                    int c = requestChannel.read(buf);
                    buf.flip();
                    if (c == -1) {
                        throw UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData();
                    }
                    if (c == 0) continue;
                    parser.parse(buf);
                }
                this.exchange.putAttachment(FORM_DATA, this.data);
            }
            catch (MalformedMessageException e) {
                throw new IOException(e);
            }
            finally {
                resource.free();
            }
            return (FormData)this.exchange.getAttachment(FORM_DATA);
        }

        @Override
        public void run() {
            try {
                this.parseBlocking();
                Connectors.executeRootHandler(this.handler, this.exchange);
            }
            catch (Throwable e) {
                UndertowLogger.REQUEST_LOGGER.debug("Exception parsing data", e);
                this.exchange.setResponseCode(500);
                this.exchange.endExchange();
            }
        }

        @Override
        public void beginPart(HeaderMap headers) {
            this.currentFileSize = 0L;
            this.headers = headers;
            String disposition = headers.getFirst(Headers.CONTENT_DISPOSITION);
            if (disposition != null && disposition.startsWith("form-data")) {
                this.currentName = Headers.extractQuotedValueFromHeader(disposition, "name");
                this.fileName = Headers.extractQuotedValueFromHeader(disposition, "filename");
                if (this.fileName != null) {
                    try {
                        this.file = File.createTempFile("undertow", "upload", MultiPartParserDefinition.this.tempFileLocation);
                        this.createdFiles.add(this.file);
                        this.fileChannel = this.exchange.getConnection().getWorker().getXnio().openFile(this.file, FileAccess.READ_WRITE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        public void data(ByteBuffer buffer) throws IOException {
            this.currentFileSize += (long)buffer.remaining();
            if (this.maxIndividualFileSize > 0L && this.currentFileSize > this.maxIndividualFileSize) {
                throw UndertowMessages.MESSAGES.maxFileSizeExceeded(this.maxIndividualFileSize);
            }
            if (this.file == null) {
                while (buffer.hasRemaining()) {
                    this.contentBytes.write(buffer.get());
                }
            } else {
                this.fileChannel.write(buffer);
            }
        }

        @Override
        public void endPart() {
            if (this.file != null) {
                this.data.add(this.currentName, this.file, this.fileName, this.headers);
                this.file = null;
                try {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                String cs;
                String charset = this.defaultEncoding;
                String contentType = this.headers.getFirst(Headers.CONTENT_TYPE);
                if (contentType != null && (cs = Headers.extractQuotedValueFromHeader(contentType, "charset")) != null) {
                    charset = cs;
                }
                this.data.add(this.currentName, new String(this.contentBytes.toByteArray(), charset), this.headers);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.contentBytes.reset();
        }

        public List<File> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public void close() throws IOException {
            this.exchange.dispatch(new Runnable(){

                @Override
                public void run() {
                    for (File file : MultiPartUploadHandler.this.getCreatedFiles()) {
                        if (!file.exists() || file.delete()) continue;
                        UndertowLogger.REQUEST_LOGGER.cannotRemoveUploadedFile(file);
                    }
                }
            });
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.defaultEncoding = encoding;
        }
    }
}

