/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class GracefulShutdownHandler
implements HttpHandler {
    private volatile boolean shutdown = false;
    private final GracefulShutdownListener listener = new GracefulShutdownListener();
    private final List<ShutdownListener> shutdownListeners = new ArrayList<ShutdownListener>();
    private final Object lock = new Object();
    private volatile long activeRequests = 0L;
    private static final AtomicLongFieldUpdater<GracefulShutdownHandler> activeRequestsUpdater = AtomicLongFieldUpdater.newUpdater(GracefulShutdownHandler.class, "activeRequests");
    private final HttpHandler next;

    public GracefulShutdownHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        activeRequestsUpdater.incrementAndGet(this);
        if (this.shutdown) {
            this.decrementRequests();
            exchange.setResponseCode(503);
            exchange.endExchange();
            return;
        }
        exchange.addExchangeCompleteListener(this.listener);
        this.next.handleRequest(exchange);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            this.shutdown = false;
            for (ShutdownListener listener : this.shutdownListeners) {
                listener.shutdown(false);
            }
            this.shutdownListeners.clear();
        }
    }

    private void shutdownComplete() {
        assert (Thread.holdsLock(this.lock));
        this.lock.notifyAll();
        for (ShutdownListener listener : this.shutdownListeners) {
            listener.shutdown(true);
        }
        this.shutdownListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            while (activeRequestsUpdater.get(this) > 0L) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitShutdown(long millis) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            long end = System.currentTimeMillis() + millis;
            int count = (int)activeRequestsUpdater.get(this);
            while (count != 0) {
                long left = end - System.currentTimeMillis();
                if (left <= 0L) {
                    return false;
                }
                this.lock.wait(left);
                count = (int)activeRequestsUpdater.get(this);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownListener(ShutdownListener shutdownListener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                throw UndertowMessages.MESSAGES.handlerNotShutdown();
            }
            long count = activeRequestsUpdater.get(this);
            if (count == 0L) {
                shutdownListener.shutdown(true);
            } else {
                this.shutdownListeners.add(shutdownListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementRequests() {
        long active = activeRequestsUpdater.decrementAndGet(this);
        if (this.shutdown) {
            Object object = this.lock;
            synchronized (object) {
                if (active == 0L) {
                    this.shutdownComplete();
                }
            }
        }
    }

    public static interface ShutdownListener {
        public void shutdown(boolean var1);
    }

    private final class GracefulShutdownListener
    implements ExchangeCompletionListener {
        private GracefulShutdownListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                GracefulShutdownHandler.this.decrementRequests();
            }
            finally {
                nextListener.proceed();
            }
        }
    }
}

