/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.results.ScalarDerivativeResult;
import org.openjdk.jmh.runner.options.IntegerValueConverter;
import org.openjdk.jmh.util.SampleBuffer;
import org.openjdk.jmh.util.Statistics;

public class PausesProfiler
implements InternalProfiler {
    private Ticker ticker;
    private SampleBuffer buffer;
    private long expectedNs;
    private long thresh;

    @Override
    public String getDescription() {
        return "Pauses profiler";
    }

    public PausesProfiler(String initLine) throws ProfilerException {
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter(PausesProfiler.class.getCanonicalName()));
        ArgumentAcceptingOptionSpec<Integer> optSamplePeriod = parser.accepts("period", "Sampling period, in us. Smaller values improve accuracy, at the expense of more profiling overhead.").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int").defaultsTo(50, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optThreshold = parser.accepts("threshold", "Threshold to filter pauses, in us. If unset, the threshold is figured during the initial calibration.").withRequiredArg().withValuesConvertedBy(IntegerValueConverter.POSITIVE).describedAs("int").defaultsTo(-1, (Integer[])new Integer[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.expectedNs = TimeUnit.MICROSECONDS.toNanos(set.valueOf(optSamplePeriod).intValue());
            this.thresh = set.valueOf(optThreshold) != -1 ? TimeUnit.MICROSECONDS.toNanos(set.valueOf(optThreshold).intValue()) : this.calibrate();
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.buffer = new SampleBuffer();
        this.ticker = new Ticker(this.buffer);
        this.ticker.start();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams, IterationResult result) {
        this.ticker.interrupt();
        try {
            this.ticker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Collections.singletonList(new PausesProfilerResult(this.buffer));
    }

    private long calibrate() {
        SampleBuffer buf = new SampleBuffer();
        long lastTime = System.nanoTime();
        for (int c = 0; c < 10000; ++c) {
            LockSupport.parkNanos(this.expectedNs);
            long time = System.nanoTime();
            long actualNs = time - lastTime;
            long delta = actualNs - this.expectedNs;
            if (delta > 0L) {
                buf.add(delta);
            }
            lastTime = time;
        }
        Statistics stat = buf.getStatistics(1.0);
        return (long)stat.getMax();
    }

    static class PausesProfilerResult
    extends Result<PausesProfilerResult> {
        private final SampleBuffer buffer;

        public PausesProfilerResult(SampleBuffer buffer) {
            super(ResultRole.SECONDARY, "\u00b7pauses", buffer.getStatistics(1.0E-6), "ms", AggregationPolicy.SUM);
            this.buffer = buffer;
        }

        @Override
        protected Aggregator<PausesProfilerResult> getThreadAggregator() {
            return new JoiningAggregator();
        }

        @Override
        protected Aggregator<PausesProfilerResult> getIterationAggregator() {
            return new JoiningAggregator();
        }

        @Override
        protected Collection<? extends Result> getDerivativeResults() {
            return Arrays.asList(new ScalarDerivativeResult("\u00b7pauses.avg", this.statistics.getMean(), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.count", this.statistics.getN(), "#", AggregationPolicy.SUM), new ScalarDerivativeResult("\u00b7pauses.p0.00", this.statistics.getMin(), "ms", AggregationPolicy.MIN), new ScalarDerivativeResult("\u00b7pauses.p0.50", this.statistics.getPercentile(50.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p0.90", this.statistics.getPercentile(90.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p0.95", this.statistics.getPercentile(95.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p0.99", this.statistics.getPercentile(99.0), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p0.999", this.statistics.getPercentile(99.9), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p0.9999", this.statistics.getPercentile(99.99), "ms", AggregationPolicy.AVG), new ScalarDerivativeResult("\u00b7pauses.p1.00", this.statistics.getMax(), "ms", AggregationPolicy.MAX));
        }

        private static class JoiningAggregator
        implements Aggregator<PausesProfilerResult> {
            private JoiningAggregator() {
            }

            @Override
            public PausesProfilerResult aggregate(Collection<PausesProfilerResult> results) {
                SampleBuffer buffer = new SampleBuffer();
                for (PausesProfilerResult r : results) {
                    buffer.addAll(r.buffer);
                }
                return new PausesProfilerResult(buffer);
            }
        }
    }

    private class Ticker
    extends Thread {
        private final SampleBuffer buffer;

        public Ticker(SampleBuffer buffer) {
            this.buffer = buffer;
            this.setPriority(10);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long lastTime = System.nanoTime();
            while (!Thread.interrupted()) {
                LockSupport.parkNanos(PausesProfiler.this.expectedNs);
                long time = System.nanoTime();
                long actualNs = time - lastTime;
                long delta = actualNs - PausesProfiler.this.expectedNs;
                if (delta > PausesProfiler.this.thresh) {
                    this.buffer.add(delta + PausesProfiler.this.expectedNs / 2L);
                }
                lastTime = time;
            }
        }
    }
}

