/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js;

import io.undertow.js.InjectionContext;
import io.undertow.js.InjectionProvider;
import io.undertow.js.UndertowScriptLogger;
import io.undertow.js.templates.TemplateProvider;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.AttachmentKey;
import io.undertow.util.FileUtils;
import io.undertow.util.Methods;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class UndertowJS {
    private static final AttachmentKey<HttpHandler> NEXT = AttachmentKey.create(HttpHandler.class);
    public static final int HOT_DEPLOYMENT_INTERVAL = 500;
    private final List<ResourceSet> resources;
    private final boolean hotDeployment;
    private final Map<ResourceSet, ResourceChangeListener> listeners = new IdentityHashMap<ResourceSet, ResourceChangeListener>();
    private final ClassLoader classLoader;
    private final Map<String, InjectionProvider> injectionProviders;
    private final JavabeanIntrospector javabeanIntrospector = new JavabeanIntrospector();
    private final List<HandlerWrapper> handlerWrappers;
    private final ResourceManager resourceManager;
    private final Map<String, TemplateProvider> templateProviders;
    private ScriptEngine engine;
    private HttpHandler routingHandler;
    private Map<Resource, Date> lastModified;
    private volatile long lastHotDeploymentCheck = -1L;
    private volatile Set<String> rejectPaths = Collections.emptySet();

    public UndertowJS(List<ResourceSet> resources, boolean hotDeployment, ClassLoader classLoader, Map<String, InjectionProvider> injectionProviders, List<HandlerWrapper> handlerWrappers, ResourceManager resourceManager, Map<String, TemplateProvider> templateProviders) {
        this.classLoader = classLoader;
        this.injectionProviders = injectionProviders;
        this.handlerWrappers = handlerWrappers;
        this.resources = new ArrayList<ResourceSet>(resources);
        this.hotDeployment = hotDeployment;
        this.resourceManager = resourceManager;
        this.templateProviders = templateProviders;
    }

    public UndertowJS start() throws ScriptException, IOException {
        this.buildEngine();
        return this;
    }

    public Object evaluate(String code) throws ScriptException {
        return this.engine.eval(code);
    }

    private synchronized void buildEngine() throws ScriptException, IOException {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        RoutingHandler routingHandler = new RoutingHandler(true);
        routingHandler.setFallbackHandler(new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                ((HttpHandler)exchange.getAttachment(NEXT)).handleRequest(exchange);
            }
        });
        RoutingHandler wsRoutingHandler = new RoutingHandler(false);
        wsRoutingHandler.setFallbackHandler((HttpHandler)routingHandler);
        for (TemplateProvider templateProvider : this.templateProviders.values()) {
            templateProvider.init(Collections.emptyMap(), this.resourceManager);
        }
        UndertowSupport support = new UndertowSupport(routingHandler, this.classLoader, this.injectionProviders, this.javabeanIntrospector, this.handlerWrappers, this.resourceManager, wsRoutingHandler, this.templateProviders);
        engine.put("$undertow_support", support);
        engine.put("javax.script.filename", "undertow-core-scripts.js");
        engine.eval(FileUtils.readFile(UndertowJS.class, (String)"undertow-core-scripts.js"));
        HashMap<Resource, Date> lm = new HashMap<Resource, Date>();
        HashSet<String> rejectPaths = new HashSet<String>();
        for (ResourceSet set : this.resources) {
            for (String resource : set.getResources()) {
                if (resource.startsWith("/")) {
                    rejectPaths.add(resource);
                } else {
                    rejectPaths.add("/" + resource);
                }
                Resource res = set.getResourceManager().getResource(resource);
                if (res == null) {
                    UndertowScriptLogger.ROOT_LOGGER.couldNotReadResource(resource);
                    continue;
                }
                try (InputStream stream = res.getUrl().openStream();){
                    engine.put("javax.script.filename", res.getUrl().toString());
                    engine.eval(new InputStreamReader(new BufferedInputStream(stream)));
                }
                if (!this.hotDeployment) continue;
                lm.put(res, res.getLastModified());
            }
        }
        this.engine = engine;
        this.routingHandler = wsRoutingHandler;
        this.lastModified = lm;
        this.rejectPaths = Collections.unmodifiableSet(rejectPaths);
    }

    public UndertowJS stop() {
        for (Map.Entry<ResourceSet, ResourceChangeListener> entry : this.listeners.entrySet()) {
            entry.getKey().getResourceManager().removeResourceChangeListener(entry.getValue());
        }
        this.listeners.clear();
        for (TemplateProvider templateProvider : this.templateProviders.values()) {
            templateProvider.cleanup();
        }
        this.engine = null;
        return this;
    }

    public HttpHandler getHandler(final HttpHandler next) {
        return new HttpHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                if (UndertowJS.this.hotDeployment) {
                    long lastHotDeploymentCheck = UndertowJS.this.lastHotDeploymentCheck;
                    if (System.currentTimeMillis() > lastHotDeploymentCheck + 500L) {
                        UndertowJS undertowJS = UndertowJS.this;
                        synchronized (undertowJS) {
                            if (UndertowJS.this.lastHotDeploymentCheck == lastHotDeploymentCheck) {
                                for (Map.Entry entry : UndertowJS.this.lastModified.entrySet()) {
                                    if (((Date)entry.getValue()).equals(((Resource)entry.getKey()).getLastModified())) continue;
                                    UndertowScriptLogger.ROOT_LOGGER.rebuildingDueToFileChange(((Resource)entry.getKey()).getPath());
                                    UndertowJS.this.buildEngine();
                                    break;
                                }
                                UndertowJS.this.lastHotDeploymentCheck = System.currentTimeMillis();
                            }
                        }
                    }
                }
                if (UndertowJS.this.rejectPaths.contains(exchange.getRelativePath())) {
                    exchange.setResponseCode(404);
                    exchange.endExchange();
                    return;
                }
                exchange.putAttachment(NEXT, (Object)next);
                UndertowJS.this.routingHandler.handleRequest(exchange);
            }
        };
    }

    public HandlerWrapper getHandlerWrapper() {
        return new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                return UndertowJS.this.getHandler(handler);
            }
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class DefaultInjectionContext
    implements InjectionContext {
        private final String name;
        private Runnable requestHandledCallback;

        DefaultInjectionContext(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setRequestHandledCallback(Runnable callback) {
            this.requestHandledCallback = callback;
        }

        @Override
        public Runnable getRequestHandledCallback() {
            return this.requestHandledCallback;
        }
    }

    public static class UndertowSupport {
        private final RoutingHandler routingHandler;
        private final ClassLoader classLoader;
        private final Map<String, InjectionProvider> injectionProviders;
        private final JavabeanIntrospector javabeanIntrospector;
        private final List<HandlerWrapper> handlerWrappers;
        private final ResourceManager resourceManager;
        private final RoutingHandler wsRoutingHandler;
        private final Map<String, TemplateProvider> templateProviders;

        public UndertowSupport(RoutingHandler routingHandler, ClassLoader classLoader, Map<String, InjectionProvider> injectionProviders, JavabeanIntrospector javabeanIntrospector, List<HandlerWrapper> handlerWrappers, ResourceManager resourceManager, RoutingHandler wsRoutingHandler, Map<String, TemplateProvider> templateProviders) {
            this.routingHandler = routingHandler;
            this.classLoader = classLoader;
            this.injectionProviders = injectionProviders;
            this.javabeanIntrospector = javabeanIntrospector;
            this.handlerWrappers = handlerWrappers;
            this.resourceManager = resourceManager;
            this.wsRoutingHandler = wsRoutingHandler;
            this.templateProviders = templateProviders;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Map<String, InjectionProvider> getInjectionProviders() {
            return this.injectionProviders;
        }

        public JavabeanIntrospector getJavabeanIntrospector() {
            return this.javabeanIntrospector;
        }

        public List<HandlerWrapper> getHandlerWrappers() {
            return this.handlerWrappers;
        }

        public RoutingHandler getRoutingHandler() {
            return this.routingHandler;
        }

        public ResourceManager getResourceManager() {
            return this.resourceManager;
        }

        public Map<String, TemplateProvider> getTemplateProviders() {
            return this.templateProviders;
        }

        public void addWebsocket(String path, WebSocketConnectionCallback callback) {
            this.wsRoutingHandler.add(Methods.GET, path, (HttpHandler)new WebSocketProtocolHandshakeHandler(callback, (HttpHandler)this.routingHandler));
        }

        public InjectionContext getInjectionContext(String name) {
            return new DefaultInjectionContext(name);
        }
    }

    public static final class JavabeanIntrospector {
        private Map<Class<?>, Map<String, Method>> cache = new ConcurrentHashMap();

        private JavabeanIntrospector() {
        }

        public Map<String, Method> inspect(Class<?> clazz) {
            Map<String, Method> existing = this.cache.get(clazz);
            if (existing != null) {
                return existing;
            }
            existing = new HashMap<String, Method>();
            for (Method method : clazz.getMethods()) {
                if (method.isBridge() || Modifier.isStatic(method.getModifiers()) || method.getName().equals("getClass") || method.getParameterCount() != 0 || !method.getName().startsWith("get") || method.getName().length() <= 3 || method.getReturnType() == Void.TYPE) continue;
                existing.put(Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4), method);
            }
            this.cache.put(clazz, existing);
            return existing;
        }
    }

    public static class ResourceSet {
        private final ResourceManager resourceManager;
        private final List<String> resources = new ArrayList<String>();

        ResourceSet(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
        }

        public ResourceManager getResourceManager() {
            return this.resourceManager;
        }

        public ResourceSet addResource(String resource) {
            this.resources.add(resource);
            return this;
        }

        public ResourceSet addResources(String ... resource) {
            this.resources.addAll(Arrays.asList(resource));
            return this;
        }

        public ResourceSet addResources(Collection<String> resource) {
            this.resources.addAll(resource);
            return this;
        }

        public List<String> getResources() {
            return Collections.unmodifiableList(this.resources);
        }
    }

    public static class Builder {
        private final List<ResourceSet> resources = new ArrayList<ResourceSet>();
        private boolean hotDeployment = true;
        private ClassLoader classLoader = UndertowJS.class.getClassLoader();
        private final Map<String, InjectionProvider> injectionProviders = new HashMap<String, InjectionProvider>();
        private final List<HandlerWrapper> handlerWrappers = new ArrayList<HandlerWrapper>();
        private ResourceManager resourceManager;
        private final Map<String, TemplateProvider> templateProviders = new HashMap<String, TemplateProvider>();

        Builder() {
        }

        public ResourceSet addResourceSet(ResourceManager manager) {
            ResourceSet resourceSet = new ResourceSet(manager);
            this.resources.add(resourceSet);
            return resourceSet;
        }

        public Builder addResources(ResourceManager manager, String ... resources) {
            ResourceSet resourceSet = new ResourceSet(manager);
            resourceSet.addResources(resources);
            this.resources.add(resourceSet);
            return this;
        }

        public Builder addResources(ResourceManager manager, Collection<String> resources) {
            ResourceSet resourceSet = new ResourceSet(manager);
            resourceSet.addResources(resources);
            this.resources.add(resourceSet);
            return this;
        }

        public boolean isHotDeployment() {
            return this.hotDeployment;
        }

        public Builder setHotDeployment(boolean hotDeployment) {
            this.hotDeployment = hotDeployment;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder addInjectionProvider(InjectionProvider provider) {
            this.injectionProviders.put(provider.getPrefix(), provider);
            return this;
        }

        public Builder addHandlerWrapper(HandlerWrapper handlerWrapper) {
            this.handlerWrappers.add(handlerWrapper);
            return this;
        }

        public Builder setResourceManager(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
            return this;
        }

        public Builder addTemplateProvider(TemplateProvider provider) {
            this.templateProviders.put(provider.name(), provider);
            return this;
        }

        public UndertowJS build() {
            return new UndertowJS(this.resources, this.hotDeployment, this.classLoader, this.injectionProviders, this.handlerWrappers, this.resourceManager, this.templateProviders);
        }
    }
}

