/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.concurrent.Threads;
import io.airlift.json.JsonCodec;
import io.trino.plugin.thrift.api.TrinoThriftBlock;
import io.trino.plugin.thrift.api.TrinoThriftColumnMetadata;
import io.trino.plugin.thrift.api.TrinoThriftId;
import io.trino.plugin.thrift.api.TrinoThriftNullableColumnSet;
import io.trino.plugin.thrift.api.TrinoThriftNullableSchemaName;
import io.trino.plugin.thrift.api.TrinoThriftNullableTableMetadata;
import io.trino.plugin.thrift.api.TrinoThriftNullableToken;
import io.trino.plugin.thrift.api.TrinoThriftPageResult;
import io.trino.plugin.thrift.api.TrinoThriftSchemaTableName;
import io.trino.plugin.thrift.api.TrinoThriftService;
import io.trino.plugin.thrift.api.TrinoThriftServiceException;
import io.trino.plugin.thrift.api.TrinoThriftSplit;
import io.trino.plugin.thrift.api.TrinoThriftSplitBatch;
import io.trino.plugin.thrift.api.TrinoThriftTableMetadata;
import io.trino.plugin.thrift.api.TrinoThriftTupleDomain;
import io.trino.plugin.thrift.server.SplitInfo;
import io.trino.plugin.tpch.DecimalTypeMapping;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchRecordSet;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchEntity;
import io.trino.tpch.TpchTable;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ThriftTpchService
implements TrinoThriftService,
Closeable {
    private static final int DEFAULT_NUMBER_OF_SPLITS = 3;
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"tiny", (Object)"sf1");
    protected static final JsonCodec<SplitInfo> SPLIT_INFO_CODEC = JsonCodec.jsonCodec(SplitInfo.class);
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), Threads.threadsNamed((String)"thrift-tpch-%s")));

    public final List<String> listSchemaNames() {
        return SCHEMAS;
    }

    public final List<TrinoThriftSchemaTableName> listTables(TrinoThriftNullableSchemaName schemaNameOrNull) {
        ArrayList<TrinoThriftSchemaTableName> tables = new ArrayList<TrinoThriftSchemaTableName>();
        for (String schemaName : ThriftTpchService.getSchemaNames(schemaNameOrNull.getSchemaName())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                tables.add(new TrinoThriftSchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return tables;
    }

    public final TrinoThriftNullableTableMetadata getTableMetadata(TrinoThriftSchemaTableName schemaTableName) {
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        if (!SCHEMAS.contains(schemaName) || TpchTable.getTables().stream().noneMatch(table -> table.getTableName().equals(tableName))) {
            return new TrinoThriftNullableTableMetadata(null);
        }
        TpchTable tpchTable = TpchTable.getTable((String)schemaTableName.getTableName());
        ArrayList<TrinoThriftColumnMetadata> columns = new ArrayList<TrinoThriftColumnMetadata>();
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add(new TrinoThriftColumnMetadata(column.getSimplifiedColumnName(), ThriftTpchService.getTypeString(column), null, false));
        }
        List<Set<String>> indexableKeys = this.getIndexableKeys(schemaName, tableName);
        return new TrinoThriftNullableTableMetadata(new TrinoThriftTableMetadata(schemaTableName, columns, null, !indexableKeys.isEmpty() ? indexableKeys : null));
    }

    protected List<Set<String>> getIndexableKeys(String schemaName, String tableName) {
        return ImmutableList.of();
    }

    public final ListenableFuture<TrinoThriftSplitBatch> getSplits(TrinoThriftSchemaTableName schemaTableName, TrinoThriftNullableColumnSet desiredColumns, TrinoThriftTupleDomain outputConstraint, int maxSplitCount, TrinoThriftNullableToken nextToken) {
        return this.executor.submit(() -> ThriftTpchService.getSplitsSync(schemaTableName, maxSplitCount, nextToken));
    }

    private static TrinoThriftSplitBatch getSplitsSync(TrinoThriftSchemaTableName schemaTableName, int maxSplitCount, TrinoThriftNullableToken nextToken) {
        int totalParts = 3;
        int partNumber = nextToken.getToken() == null ? 0 : Ints.fromByteArray((byte[])nextToken.getToken().getId());
        int numberOfSplits = Math.min(maxSplitCount, totalParts - partNumber);
        ArrayList<TrinoThriftSplit> splits = new ArrayList<TrinoThriftSplit>(numberOfSplits);
        for (int i = 0; i < numberOfSplits; ++i) {
            SplitInfo splitInfo = SplitInfo.normalSplit(schemaTableName.getSchemaName(), schemaTableName.getTableName(), partNumber + 1, totalParts);
            splits.add(new TrinoThriftSplit(new TrinoThriftId(SPLIT_INFO_CODEC.toJsonBytes((Object)splitInfo)), (List)ImmutableList.of()));
            ++partNumber;
        }
        TrinoThriftId newNextToken = partNumber < totalParts ? new TrinoThriftId(Ints.toByteArray((int)partNumber)) : null;
        return new TrinoThriftSplitBatch(splits, newNextToken);
    }

    public final ListenableFuture<TrinoThriftSplitBatch> getIndexSplits(TrinoThriftSchemaTableName schemaTableName, List<String> indexColumnNames, List<String> outputColumnNames, TrinoThriftPageResult keys, TrinoThriftTupleDomain outputConstraint, int maxSplitCount, TrinoThriftNullableToken nextToken) {
        return this.executor.submit(() -> this.getIndexSplitsSync(schemaTableName, indexColumnNames, keys, maxSplitCount, nextToken));
    }

    protected TrinoThriftSplitBatch getIndexSplitsSync(TrinoThriftSchemaTableName schemaTableName, List<String> indexColumnNames, TrinoThriftPageResult keys, int maxSplitCount, TrinoThriftNullableToken nextToken) throws TrinoThriftServiceException {
        throw new TrinoThriftServiceException("Index join is not supported", false);
    }

    public final ListenableFuture<TrinoThriftPageResult> getRows(TrinoThriftId splitId, List<String> outputColumns, long maxBytes, TrinoThriftNullableToken nextToken) {
        return this.executor.submit(() -> this.getRowsSync(splitId, outputColumns, maxBytes, nextToken));
    }

    private TrinoThriftPageResult getRowsSync(TrinoThriftId splitId, List<String> outputColumns, long maxBytes, TrinoThriftNullableToken nextToken) {
        SplitInfo splitInfo = (SplitInfo)SPLIT_INFO_CODEC.fromJson(splitId.getId());
        Preconditions.checkArgument((maxBytes >= 0x100000L ? 1 : 0) != 0, (Object)"requested maxBytes is too small");
        ConnectorPageSource pageSource = !splitInfo.isIndexSplit() ? ThriftTpchService.createPageSource(splitInfo, outputColumns) : this.createLookupPageSource(splitInfo, outputColumns);
        return ThriftTpchService.getRowsInternal(pageSource, splitInfo.getTableName(), outputColumns, nextToken.getToken());
    }

    protected ConnectorPageSource createLookupPageSource(SplitInfo splitInfo, List<String> outputColumnNames) {
        throw new UnsupportedOperationException("lookup is not supported");
    }

    @Override
    @PreDestroy
    public final void close() {
        this.executor.shutdownNow();
    }

    public static List<Type> types(String tableName, List<String> columnNames) {
        TpchTable table = TpchTable.getTable((String)tableName);
        return columnNames.stream().map(name -> TpchMetadata.getTrinoType((TpchColumn)table.getColumn(name), (DecimalTypeMapping)DecimalTypeMapping.DOUBLE)).collect(Collectors.toList());
    }

    public static double schemaNameToScaleFactor(String schemaName) {
        switch (schemaName) {
            case "tiny": {
                return 0.01;
            }
            case "sf1": {
                return 1.0;
            }
        }
        throw new IllegalArgumentException("Schema is not setup: " + schemaName);
    }

    private static TrinoThriftPageResult getRowsInternal(ConnectorPageSource pageSource, String tableName, List<String> columnNames, @Nullable TrinoThriftId nextToken) {
        int skipPages = nextToken != null ? Ints.fromByteArray((byte[])nextToken.getId()) : 0;
        ThriftTpchService.skipPages(pageSource, skipPages);
        Page page = null;
        while (!pageSource.isFinished() && page == null) {
            page = pageSource.getNextPage();
            ++skipPages;
        }
        TrinoThriftId newNextToken = pageSource.isFinished() ? null : new TrinoThriftId(Ints.toByteArray((int)skipPages));
        return ThriftTpchService.toThriftPage(page, ThriftTpchService.types(tableName, columnNames), newNextToken);
    }

    private static TrinoThriftPageResult toThriftPage(Page page, List<Type> columnTypes, @Nullable TrinoThriftId nextToken) {
        if (page == null) {
            Preconditions.checkState((nextToken == null ? 1 : 0) != 0, (Object)"there must be no more data when page is null");
            return new TrinoThriftPageResult((List)ImmutableList.of(), 0, null);
        }
        Preconditions.checkState((page.getChannelCount() == columnTypes.size() ? 1 : 0) != 0, (Object)"number of columns in a page doesn't match the one in requested types");
        int numberOfColumns = columnTypes.size();
        ArrayList<TrinoThriftBlock> columnBlocks = new ArrayList<TrinoThriftBlock>(numberOfColumns);
        for (int i = 0; i < numberOfColumns; ++i) {
            columnBlocks.add(TrinoThriftBlock.fromBlock((Block)page.getBlock(i), (Type)columnTypes.get(i)));
        }
        return new TrinoThriftPageResult(columnBlocks, page.getPositionCount(), nextToken);
    }

    private static void skipPages(ConnectorPageSource pageSource, int skipPages) {
        for (int i = 0; i < skipPages; ++i) {
            Preconditions.checkState((!pageSource.isFinished() ? 1 : 0) != 0, (Object)"pageSource is unexpectedly finished");
            pageSource.getNextPage();
        }
    }

    private static ConnectorPageSource createPageSource(SplitInfo splitInfo, List<String> columnNames) {
        switch (splitInfo.getTableName()) {
            case "orders": {
                return ThriftTpchService.createPageSource(TpchTable.ORDERS, columnNames, splitInfo);
            }
            case "customer": {
                return ThriftTpchService.createPageSource(TpchTable.CUSTOMER, columnNames, splitInfo);
            }
            case "lineitem": {
                return ThriftTpchService.createPageSource(TpchTable.LINE_ITEM, columnNames, splitInfo);
            }
            case "nation": {
                return ThriftTpchService.createPageSource(TpchTable.NATION, columnNames, splitInfo);
            }
            case "region": {
                return ThriftTpchService.createPageSource(TpchTable.REGION, columnNames, splitInfo);
            }
            case "part": {
                return ThriftTpchService.createPageSource(TpchTable.PART, columnNames, splitInfo);
            }
        }
        throw new IllegalArgumentException("Table not setup: " + splitInfo.getTableName());
    }

    private static <T extends TpchEntity> ConnectorPageSource createPageSource(TpchTable<T> table, List<String> columnNames, SplitInfo splitInfo) {
        List columns = columnNames.stream().map(arg_0 -> table.getColumn(arg_0)).collect(Collectors.toList());
        return new RecordPageSource((RecordSet)TpchRecordSet.createTpchRecordSet(table, columns, (DecimalTypeMapping)DecimalTypeMapping.DOUBLE, (double)ThriftTpchService.schemaNameToScaleFactor(splitInfo.getSchemaName()), (int)splitInfo.getPartNumber(), (int)splitInfo.getTotalParts(), (TupleDomain)TupleDomain.all()));
    }

    private static List<String> getSchemaNames(String schemaNameOrNull) {
        if (schemaNameOrNull == null) {
            return SCHEMAS;
        }
        if (SCHEMAS.contains(schemaNameOrNull)) {
            return ImmutableList.of((Object)schemaNameOrNull);
        }
        return ImmutableList.of();
    }

    private static String getTypeString(TpchColumn<?> column) {
        return TpchMetadata.getTrinoType(column, (DecimalTypeMapping)DecimalTypeMapping.DOUBLE).getTypeSignature().toString();
    }
}

