/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class SplitInfo {
    private final String schemaName;
    private final String tableName;
    private final int partNumber;
    private final int totalParts;
    private final boolean indexSplit;
    private final List<String> lookupColumnNames;
    private final List<List<String>> keys;

    @JsonCreator
    public SplitInfo(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalParts") int totalParts, @JsonProperty(value="indexSplit") boolean indexSplit, @JsonProperty(value="lookupColumnNames") List<String> lookupColumnNames, @JsonProperty(value="keys") List<List<String>> keys) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.partNumber = partNumber;
        this.totalParts = totalParts;
        this.indexSplit = indexSplit;
        this.lookupColumnNames = Objects.requireNonNull(lookupColumnNames, "lookupColumnNames is null");
        this.keys = Objects.requireNonNull(keys, "keys is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    @JsonProperty
    public int getTotalParts() {
        return this.totalParts;
    }

    @JsonProperty
    public boolean isIndexSplit() {
        return this.indexSplit;
    }

    @JsonProperty
    public List<String> getLookupColumnNames() {
        return this.lookupColumnNames;
    }

    @JsonProperty
    public List<List<String>> getKeys() {
        return this.keys;
    }

    public static SplitInfo normalSplit(String schemaName, String tableName, int partNumber, int totalParts) {
        return new SplitInfo(schemaName, tableName, partNumber, totalParts, false, (List<String>)ImmutableList.of(), (List<List<String>>)ImmutableList.of());
    }

    public static SplitInfo indexSplit(String schemaName, String tableName, List<String> lookupColumnNames, List<List<String>> keys) {
        return new SplitInfo(schemaName, tableName, 0, 0, true, lookupColumnNames, keys);
    }
}

