/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

final class NameValidationUtils {
    private NameValidationUtils() {
    }

    public static String checkValidName(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        Preconditions.checkArgument(('a' <= name.charAt(0) && name.charAt(0) <= 'z' ? 1 : 0) != 0, (String)"name must start with a lowercase latin letter: '%s'", (Object)name);
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            Preconditions.checkArgument(('a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '_' ? 1 : 0) != 0, (String)"name must contain only lowercase latin letters, digits or underscores: '%s'", (Object)name);
        }
        return name;
    }
}

