/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api.valuesets;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.valuesets.TrinoThriftAllOrNoneValueSet;
import io.trino.plugin.thrift.api.valuesets.TrinoThriftEquatableValueSet;
import io.trino.plugin.thrift.api.valuesets.TrinoThriftRangeValueSet;
import io.trino.spi.predicate.AllOrNoneValueSet;
import io.trino.spi.predicate.EquatableValueSet;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.ValueSet;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftValueSet {
    private final TrinoThriftAllOrNoneValueSet allOrNoneValueSet;
    private final TrinoThriftEquatableValueSet equatableValueSet;
    private final TrinoThriftRangeValueSet rangeValueSet;

    @ThriftConstructor
    public TrinoThriftValueSet(@Nullable TrinoThriftAllOrNoneValueSet allOrNoneValueSet, @Nullable TrinoThriftEquatableValueSet equatableValueSet, @Nullable TrinoThriftRangeValueSet rangeValueSet) {
        Preconditions.checkArgument((boolean)TrinoThriftValueSet.isExactlyOneNonNull(allOrNoneValueSet, equatableValueSet, rangeValueSet), (Object)"exactly one value set must be present");
        this.allOrNoneValueSet = allOrNoneValueSet;
        this.equatableValueSet = equatableValueSet;
        this.rangeValueSet = rangeValueSet;
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftAllOrNoneValueSet getAllOrNoneValueSet() {
        return this.allOrNoneValueSet;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftEquatableValueSet getEquatableValueSet() {
        return this.equatableValueSet;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public TrinoThriftRangeValueSet getRangeValueSet() {
        return this.rangeValueSet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftValueSet other = (TrinoThriftValueSet)obj;
        return Objects.equals(this.allOrNoneValueSet, other.allOrNoneValueSet) && Objects.equals(this.equatableValueSet, other.equatableValueSet) && Objects.equals(this.rangeValueSet, other.rangeValueSet);
    }

    public int hashCode() {
        return Objects.hash(this.allOrNoneValueSet, this.equatableValueSet, this.rangeValueSet);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueSet", TrinoThriftValueSet.firstNonNull(this.allOrNoneValueSet, this.equatableValueSet, this.rangeValueSet)).toString();
    }

    public static TrinoThriftValueSet fromValueSet(ValueSet valueSet) {
        if (valueSet.getClass() == AllOrNoneValueSet.class) {
            return new TrinoThriftValueSet(TrinoThriftAllOrNoneValueSet.fromAllOrNoneValueSet((AllOrNoneValueSet)valueSet), null, null);
        }
        if (valueSet.getClass() == EquatableValueSet.class) {
            return new TrinoThriftValueSet(null, TrinoThriftEquatableValueSet.fromEquatableValueSet((EquatableValueSet)valueSet), null);
        }
        if (valueSet.getClass() == SortedRangeSet.class) {
            return new TrinoThriftValueSet(null, null, TrinoThriftRangeValueSet.fromSortedRangeSet((SortedRangeSet)valueSet));
        }
        throw new IllegalArgumentException("Unknown implementation of a value set: " + valueSet.getClass());
    }

    private static boolean isExactlyOneNonNull(Object a, Object b, Object c) {
        return a != null && b == null && c == null || a == null && b != null && c == null || a == null && b == null && c != null;
    }

    private static Object firstNonNull(Object a, Object b, Object c) {
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException("All arguments are null");
    }
}

