/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.TrinoThriftHostAddress;
import io.trino.plugin.thrift.api.TrinoThriftId;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public final class TrinoThriftSplit {
    private final TrinoThriftId splitId;
    private final List<TrinoThriftHostAddress> hosts;

    @ThriftConstructor
    public TrinoThriftSplit(TrinoThriftId splitId, List<TrinoThriftHostAddress> hosts) {
        this.splitId = Objects.requireNonNull(splitId, "splitId is null");
        this.hosts = Objects.requireNonNull(hosts, "hosts is null");
    }

    @ThriftField(value=1)
    public TrinoThriftId getSplitId() {
        return this.splitId;
    }

    @ThriftField(value=2)
    public List<TrinoThriftHostAddress> getHosts() {
        return this.hosts;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftSplit other = (TrinoThriftSplit)obj;
        return Objects.equals(this.splitId, other.splitId) && Objects.equals(this.hosts, other.hosts);
    }

    public int hashCode() {
        return Objects.hash(this.splitId, this.hosts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("splitId", (Object)this.splitId).add("hosts", this.hosts).toString();
    }
}

