/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.thrift.api;

import com.google.common.base.MoreObjects;
import io.airlift.drift.annotations.ThriftConstructor;
import io.airlift.drift.annotations.ThriftField;
import io.airlift.drift.annotations.ThriftStruct;
import io.trino.plugin.thrift.api.NameValidationUtils;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ThriftStruct
public final class TrinoThriftColumnMetadata {
    private final String name;
    private final String type;
    private final String comment;
    private final boolean hidden;

    @ThriftConstructor
    public TrinoThriftColumnMetadata(String name, String type, @Nullable String comment, boolean hidden) {
        this.name = NameValidationUtils.checkValidName(name);
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = comment;
        this.hidden = hidden;
    }

    @ThriftField(value=1)
    public String getName() {
        return this.name;
    }

    @ThriftField(value=2)
    public String getType() {
        return this.type;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public String getComment() {
        return this.comment;
    }

    @ThriftField(value=4)
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata toColumnMetadata(TypeManager typeManager) {
        return ColumnMetadata.builder().setName(this.name).setType(typeManager.fromSqlType(this.type)).setComment(Optional.ofNullable(this.comment)).setHidden(this.hidden).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrinoThriftColumnMetadata other = (TrinoThriftColumnMetadata)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.comment, other.comment) && this.hidden == other.hidden;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment, this.hidden);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("comment", (Object)this.comment).add("hidden", this.hidden).toString();
    }
}

