/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.tpch;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.tpch.TpchMetadata;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorResolvedIndex;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.testing.tpch.TpchIndexHandle;
import io.trino.testing.tpch.TpchIndexProvider;
import io.trino.testing.tpch.TpchIndexedData;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TpchIndexMetadata
extends TpchMetadata {
    private final TpchIndexedData indexedData;

    public TpchIndexMetadata(TpchIndexedData indexedData) {
        this.indexedData = Objects.requireNonNull(indexedData, "indexedData is null");
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        Map<ColumnHandle, NullableValue> fixedValues = ((Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of())).entrySet().stream().filter(entry -> !indexableColumns.contains(entry.getKey())).filter(entry -> !((NullableValue)entry.getValue()).isNull()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ImmutableSet lookupColumnNames = ImmutableSet.builder().addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(indexableColumns))).addAll(TpchIndexProvider.handleToNames((List<ColumnHandle>)ImmutableList.copyOf(fixedValues.keySet()))).build();
        if (this.indexedData.getIndexedTable(tpchTableHandle.tableName(), tpchTableHandle.scaleFactor(), (Set<String>)lookupColumnNames).isEmpty()) {
            return Optional.empty();
        }
        TupleDomain filteredTupleDomain = tupleDomain.filter((column, domain) -> !fixedValues.containsKey(column));
        TpchIndexHandle indexHandle = new TpchIndexHandle(tpchTableHandle.tableName(), tpchTableHandle.scaleFactor(), (Set<String>)lookupColumnNames, (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues(fixedValues));
        return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)indexHandle, filteredTupleDomain));
    }
}

