/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.client.JsonCodec;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.protocol.SpooledLocation;
import io.trino.spi.protocol.SpooledSegmentHandle;
import io.trino.spi.protocol.SpoolingContext;
import io.trino.spi.protocol.SpoolingManager;
import io.trino.spi.protocol.SpoolingManagerContext;
import io.trino.spi.protocol.SpoolingManagerFactory;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class LocalSpoolingManager
implements SpoolingManager {
    private static final JsonCodec<LocalSpooledSegmentHandle> HANDLE_CODEC = JsonCodec.jsonCodec(LocalSpooledSegmentHandle.class);
    private final Path rootPath;
    private final AtomicLong segmentId = new AtomicLong();

    public LocalSpoolingManager() {
        try {
            this.rootPath = Files.createTempDirectory("spooling", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public SpooledSegmentHandle create(SpoolingContext context) {
        return new LocalSpooledSegmentHandle(context.encoding(), context.queryId(), this.rootPath.resolve(context.queryId().getId() + "-" + this.segmentId.incrementAndGet() + "-" + String.valueOf(UUID.randomUUID()) + "." + context.encoding()));
    }

    public OutputStream createOutputStream(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        return Files.newOutputStream(localHandle.path(), StandardOpenOption.CREATE_NEW);
    }

    public InputStream openInputStream(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        if (!Files.exists(localHandle.path(), new LinkOption[0])) {
            throw new IOException("Segment not found or expired");
        }
        return Files.newInputStream(localHandle.path(), new OpenOption[0]);
    }

    public SpooledSegmentHandle handle(SpooledLocation location) {
        if (!(location instanceof SpooledLocation.CoordinatorLocation)) {
            throw new IllegalArgumentException("Cannot convert direct location to handle");
        }
        SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)location;
        try {
            return (SpooledSegmentHandle)HANDLE_CODEC.fromJson(coordinatorLocation.identifier().toStringUtf8());
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public SpooledLocation location(SpooledSegmentHandle handle) {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        return SpooledLocation.coordinatorLocation((Slice)Slices.utf8Slice((String)HANDLE_CODEC.toJson((Object)localHandle)), Map.of());
    }

    public void acknowledge(SpooledSegmentHandle handle) throws IOException {
        LocalSpooledSegmentHandle localHandle = (LocalSpooledSegmentHandle)handle;
        if (!Files.exists(localHandle.path(), new LinkOption[0])) {
            throw new IOException("Segment not found or expired");
        }
        Files.delete(localHandle.path());
    }

    public Optional<SpooledLocation.DirectLocation> directLocation(SpooledSegmentHandle handle) {
        throw new UnsupportedOperationException();
    }

    @PreDestroy
    public void close() {
        try {
            MoreFiles.deleteRecursively((Path)this.rootPath, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public record LocalSpooledSegmentHandle(String encoding, QueryId queryId, Path path) implements SpooledSegmentHandle
    {
        public LocalSpooledSegmentHandle {
            Objects.requireNonNull(encoding, "encoding is null");
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(path, "path is null");
        }

        public Instant expirationTime() {
            return Instant.MAX;
        }

        public String identifier() {
            return this.path.getFileName().toString();
        }
    }

    public static class LocalSpoolingFactory
    implements SpoolingManagerFactory {
        public String getName() {
            return "test-local";
        }

        public SpoolingManager create(Map<String, String> config, SpoolingManagerContext context) {
            return new LocalSpoolingManager();
        }
    }

    public static class LocalSpoolingPlugin
    implements Plugin {
        public Iterable<SpoolingManagerFactory> getSpoolingManagerFactories() {
            return List.of(new LocalSpoolingFactory());
        }
    }
}

