/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.datatype;

import io.trino.testing.datatype.ColumnSetup;
import io.trino.testing.datatype.DataSetup;
import io.trino.testing.sql.SqlExecutor;
import io.trino.testing.sql.TestTable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CreateAsSelectDataSetup
implements DataSetup {
    private final SqlExecutor sqlExecutor;
    private final String tableNamePrefix;

    public CreateAsSelectDataSetup(SqlExecutor sqlExecutor, String tableNamePrefix) {
        this.sqlExecutor = sqlExecutor;
        this.tableNamePrefix = tableNamePrefix;
    }

    @Override
    public TestTable setupTemporaryRelation(List<ColumnSetup> inputs) {
        List columnValues = inputs.stream().map(this::format).collect(Collectors.toList());
        String selectBody = IntStream.range(0, columnValues.size()).mapToObj(i -> String.format("%s col_%d", columnValues.get(i), i)).collect(Collectors.joining(",\n"));
        return new TestTable(this.sqlExecutor, this.tableNamePrefix, "AS SELECT " + selectBody);
    }

    private String format(ColumnSetup input) {
        if (input.getDeclaredType().isEmpty()) {
            return input.getInputLiteral();
        }
        return String.format("CAST(%s AS %s)", input.getInputLiteral(), input.getDeclaredType().get());
    }
}

