/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestEngineOnlyQueries;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.Assert;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public abstract class AbstractDistributedEngineOnlyQueries
extends AbstractTestEngineOnlyQueries {
    private ExecutorService executorService;

    @BeforeAll
    public void setUp() {
        this.executorService = Executors.newCachedThreadPool();
    }

    @AfterAll
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    @Test
    public void ensureDistributedQueryRunner() {
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.getQueryRunner().getNodeCount()).as("query runner node count", new Object[0])).isGreaterThanOrEqualTo(3);
    }

    @Test
    public void testTimestampWithTimeZoneLiteralsWithDifferentZone() {
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123 Europe/Warsaw'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123+01:00[Europe/Warsaw]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123 Europe/Paris'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123+01:00[Europe/Paris]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456 Europe/Warsaw'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123456+01:00[Europe/Warsaw]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456 Europe/Paris'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123456+01:00[Europe/Paris]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789 Europe/Warsaw'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123456789+01:00[Europe/Warsaw]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789 Europe/Paris'").getOnlyValue()).isEqualTo((Object)ZonedDateTime.parse("2017-01-02T09:12:34.123456789+01:00[Europe/Paris]"));
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Warsaw'").getOnlyValue()).isEqualTo((Object)"2017-01-02 09:12:34.123456789012 Europe/Warsaw");
        Assertions.assertThat((Object)this.getQueryRunner().execute("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Paris'").getOnlyValue()).isEqualTo((Object)"2017-01-02 09:12:34.123456789012 Europe/Paris");
    }

    @Test
    public void testUse() {
        this.assertQueryFails("USE invalid.xyz", "Catalog 'invalid' not found");
        this.assertQueryFails("USE tpch.invalid", "Schema does not exist: tpch.invalid");
    }

    @Test
    public void testRoles() {
        Session invalid = Session.builder((Session)this.getSession()).setCatalog("invalid").build();
        this.assertQueryFails(invalid, "CREATE ROLE test", "System roles are not enabled");
        this.assertQueryFails(invalid, "CREATE ROLE test", "System roles are not enabled");
        this.assertQueryFails(invalid, "DROP ROLE test", "line 1:1: Role 'test' does not exist");
        this.assertQueryFails(invalid, "GRANT test TO USER foo", "line 1:1: Role 'test' does not exist");
        this.assertQueryFails(invalid, "REVOKE test FROM USER foo", "line 1:1: Role 'test' does not exist");
        this.assertQueryFails(invalid, "SET ROLE test", "line 1:1: Role 'test' does not exist");
        this.assertQueryFails(invalid, "CREATE ROLE test IN invalid", "line 1:1: Catalog 'invalid' not found");
        this.assertQueryFails(invalid, "DROP ROLE test IN invalid", "line 1:1: Catalog 'invalid' not found");
        this.assertQueryFails(invalid, "GRANT test TO USER foo IN invalid", "line 1:1: Catalog 'invalid' not found");
        this.assertQueryFails(invalid, "REVOKE test FROM USER foo IN invalid", "line 1:1: Catalog 'invalid' not found");
        this.assertQueryFails(invalid, "SET ROLE test IN invalid", "line 1:1: Catalog 'invalid' not found");
    }

    @Test
    public void testDuplicatedRowCreateTable() {
        this.assertQueryFails("CREATE TABLE test (a integer, a integer)", "line 1:31: Column name 'a' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, orderkey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, A integer)", "line 1:31: Column name 'A' specified more than once");
        this.assertQueryFails("CREATE TABLE test (a integer, OrderKey integer, LIKE orders INCLUDING PROPERTIES)", "line 1:49: Column name 'orderkey' specified more than once");
    }

    @Test
    public void testTooLongQuery() {
        String longQuery = "SELECT x" + ",x".repeat(500000) + " FROM (VALUES 1,2,3,4,5) t(x)";
        this.assertQueryFails(longQuery, "Query text length \\(1000037\\) exceeds the maximum length \\(1000000\\)");
    }

    @Test
    public void testTooManyStages() {
        String query = "WITH\n  t1 AS (SELECT nationkey AS x FROM nation where name='UNITED STATES'),\n  t2 AS (SELECT a.x+b.x+c.x+d.x AS x FROM t1 a, t1 b, t1 c, t1 d),\n  t3 AS (SELECT a.x+b.x+c.x+d.x AS x FROM t2 a, t2 b, t2 c, t2 d),\n  t4 AS (SELECT a.x+b.x+c.x+d.x AS x FROM t3 a, t3 b, t3 c, t3 d),\n  t5 AS (SELECT a.x+b.x+c.x+d.x AS x FROM t4 a, t4 b, t4 c, t4 d)\nSELECT x FROM t5\n";
        this.assertQueryFails(query, "Number of stages in the query \\([0-9]+\\) exceeds the allowed maximum \\([0-9]+\\).*");
    }

    @Test
    public void testRowSubscriptWithReservedKeyword() {
        this.assertQuery("SELECT cast(row(1) AS row(\"cross\" bigint))[1]", "VALUES 1");
    }

    @Test
    public void testRowTypeWithReservedKeyword() {
        this.assertQuery("SELECT cast(row(1) AS row(\"cross\" bigint)).\"cross\"", "VALUES 1");
    }

    @Test
    public void testExplain() {
        this.assertExplain("explain select name from nation where abs(nationkey) = 22", Pattern.quote("abs(nationkey)"), "Estimates: \\{rows: .* \\(.*\\), cpu: .*, memory: .*, network: .*}", "Trino version: .*");
    }

    @Test
    public void testExplainDistributed() {
        this.assertExplain("explain (type distributed) select name from nation where abs(nationkey) = 22", Pattern.quote("abs(nationkey)"), "Estimates: \\{rows: .* \\(.*\\), cpu: .*, memory: .*, network: .*}", "Trino version: .*");
    }

    @Test
    public void testExplainAnalyze() {
        this.assertExplainAnalyze(this.noJoinReordering(OptimizerConfig.JoinDistributionType.BROADCAST), "EXPLAIN ANALYZE SELECT * FROM (SELECT nationkey, regionkey FROM nation GROUP BY nationkey, regionkey) a, nation b WHERE a.regionkey = b.regionkey", "Trino version: .*");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM nation a, nation b WHERE a.nationkey = b.nationkey", "Left \\(probe\\) Input avg\\.: .* rows, Input std\\.dev\\.: .*", "Right \\(build\\) Input avg\\.: .* rows, Input std\\.dev\\.: .*");
        this.assertExplainAnalyze(Session.builder((Session)this.getSession()).setSystemProperty("enable_dynamic_filtering", "false").build(), "EXPLAIN ANALYZE SELECT * FROM nation a, nation b WHERE a.nationkey = b.nationkey", "Left \\(probe\\) Input avg\\.: .* rows, Input std\\.dev\\.: .*", "Right \\(build\\) Input avg\\.: .* rows, Input std\\.dev\\.: .*");
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM nation a, nation b WHERE a.nationkey = b.nationkey", "Estimates: \\{rows: .* \\(.*\\), cpu: .*, memory: .*, network: .*}");
    }

    @Test
    public void testExplainAnalyzeDynamicFilterInfo() {
        Assert.assertEventually(() -> this.assertExplainAnalyze(Session.builder((Session)this.getSession()).setSystemProperty("enable_large_dynamic_filters", "true").build(), "EXPLAIN ANALYZE SELECT * FROM nation a, nation b WHERE a.nationkey = b.nationkey", "Dynamic filters: \n.*ranges=25, \\{\\[0], ..., \\[24]}.* collection time=\\d+.*"));
    }

    @Test
    public void testExplainAnalyzeVerbose() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE VERBOSE SELECT * FROM nation a", "'Input rows distribution' = \\{count=.*, p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, min=.*, max=.*}", "'CPU time distribution \\(s\\)' = \\{count=.*, p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, min=.*, max=.*}", "'Scheduled time distribution \\(s\\)' = \\{count=.*, p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, min=.*, max=.*}", "Output buffer active time: .*, buffer utilization distribution \\(%\\): \\{p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, max=.*}", "Task output distribution: \\{count=.*, p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, max=.*}", "Task input distribution: \\{count=.*, p01=.*, p05=.*, p10=.*, p25=.*, p50=.*, p75=.*, p90=.*, p95=.*, p99=.*, max=.*}", "Trino version: .*");
    }

    @Test
    public void testExplainAnalyzeTopLevelTimes() {
        this.assertExplainAnalyze("EXPLAIN ANALYZE SELECT * FROM nation a", "Queued: .*s, Analysis: .*s, Planning: .*s, Execution: .*s\n");
    }

    @Test
    public void testInsertWithCoercion() {
        String tableName = "test_insert_with_coercion_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " (tinyint_column tinyint, integer_column integer, decimal_column decimal(5, 3), real_column real, char_column char(3), bounded_varchar_column varchar(3), unbounded_varchar_column varchar, date_column date)");
        this.assertUpdate("INSERT INTO " + tableName + " (tinyint_column, integer_column, decimal_column, real_column) VALUES (1e0, 2e0, 3e0, 4e0)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (VARCHAR 'aa     ', VARCHAR 'aa     ', VARCHAR 'aa     ')", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (NULL, NULL, NULL)", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (CAST(NULL AS varchar), CAST(NULL AS varchar), CAST(NULL AS varchar))", 1L);
        this.assertUpdate("INSERT INTO " + tableName + " (date_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')", 1L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES (1, 2, 3, 4, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, 'aa ', 'aa ', 'aa     ', NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL), (NULL, NULL, NULL, NULL, NULL, NULL, NULL, DATE '2019-11-18')");
        this.assertQueryFails("INSERT INTO " + tableName + " (integer_column) VALUES (3e9)", "Out of range for integer: 3.0E9");
        this.assertQueryFails("INSERT INTO " + tableName + " (char_column) VALUES ('abcd')", "\\QCannot truncate non-space characters when casting from varchar(4) to char(3) on INSERT");
        this.assertQueryFails("INSERT INTO " + tableName + " (bounded_varchar_column) VALUES ('abcd')", "\\QCannot truncate non-space characters when casting from varchar(4) to varchar(3) on INSERT");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    @Test
    public void testCreateTableAsTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*) FROM information_schema.columns WHERE table_catalog = 'tpch' and table_schema = 'tiny' and table_name = 'nation' and column_name = 'row_number'"))).matches("VALUES BIGINT '0'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT min(row_number) FROM tpch.tiny.nation"))).matches("VALUES BIGINT '0'");
        this.assertUpdate(this.getSession(), "CREATE TABLE n AS TABLE tpch.tiny.nation", 25L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM n"))).matches("SELECT * FROM tpch.tiny.nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT min(row_number) FROM n"))).failure().hasMessage("line 1:12: Column 'row_number' cannot be resolved");
        this.assertUpdate(this.getSession(), "DROP TABLE n");
    }

    @Test
    public void testInsertTableIntoTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT count(*) FROM information_schema.columns WHERE table_catalog = 'tpch' and table_schema = 'tiny' and table_name = 'nation' and column_name = 'row_number'"))).matches("VALUES BIGINT '0'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT min(row_number) FROM tpch.tiny.nation"))).matches("VALUES BIGINT '0'");
        this.assertUpdate(this.getSession(), "CREATE TABLE n AS TABLE tpch.tiny.nation WITH NO DATA", 0L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM n"))).matches("SELECT * FROM tpch.tiny.nation LIMIT 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT row_number FROM n"))).failure().hasMessage("line 1:8: Column 'row_number' cannot be resolved");
        this.assertUpdate(this.getSession(), "INSERT INTO n TABLE tpch.tiny.nation", 25L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.query("SELECT * FROM n"))).matches("SELECT * FROM tpch.tiny.nation");
        this.assertUpdate(this.getSession(), "DROP TABLE n");
    }

    @Test
    public void testImplicitCastToRowWithFieldsRequiringDelimitation() {
        this.assertUpdate("CREATE TABLE source_table(r ROW(a char(4), b char(4)))");
        this.assertUpdate("CREATE TABLE target_table(r ROW(\"a b\" varchar, \"from\" varchar))");
        this.assertUpdate("INSERT INTO target_table SELECT * from source_table", 0L);
    }

    @Test
    @Timeout(value=10L)
    public void testQueryTransitionsToRunningState() {
        String query = String.format("SELECT count(*) c_%s FROM lineitem CROSS JOIN lineitem CROSS JOIN lineitem", TestingNames.randomNameSuffix());
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        ListenableFuture queryFuture = Futures.submit(() -> queryRunner.execute(this.getSession(), query), (Executor)this.executorService);
        QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
        Assert.assertEventually(() -> {
            List queryInfos = (List)queryManager.getQueries().stream().filter(q -> q.getQuery().equals(query)).collect(ImmutableList.toImmutableList());
            Assertions.assertThat((List)queryInfos).hasSize(1);
            Assertions.assertThat((Comparable)((BasicQueryInfo)queryInfos.get(0)).getState()).isEqualTo((Object)QueryState.RUNNING);
            queryManager.cancelQuery(((BasicQueryInfo)queryInfos.get(0)).getQueryId());
        });
        Assertions.assertThatThrownBy(() -> queryFuture.get()).hasMessageContaining("Query was canceled");
    }

    @Test
    @Timeout(value=30L)
    public void testSelectiveLimit() {
        this.assertQuery("SELECT * FROM (   (SELECT orderkey AS a FROM tpch.sf10000.orders WHERE orderkey=-1) UNION ALL SELECT * FROM (values -1) AS t(a))WHERE a=-1 LIMIT 1", "VALUES -1");
    }

    @Test
    public void testRowConstructorColumnLimit() {
        String colNames = "orderkey, custkey, orderstatus, totalprice, orderpriority, clerk, shippriority, comment, orderdate";
        String rowFields = colNames + (", " + colNames).repeat(94) + ", orderkey, custkey,  orderstatus, totalprice";
        String query = "SELECT row(" + rowFields + ") FROM (select * from tpch.tiny.orders limit 1) t(" + colNames + ")";
        Assertions.assertThat((Object)this.getQueryRunner().execute(query).getOnlyValue()).isNotNull();
    }
}

