/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.statistics;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import java.util.Map;

public class StatsContext {
    private final Map<String, Symbol> columnSymbols;

    public StatsContext(Map<String, Symbol> columnSymbols) {
        this.columnSymbols = ImmutableMap.copyOf(columnSymbols);
    }

    public Symbol getSymbolForColumn(String columnName) {
        Preconditions.checkArgument((boolean)this.columnSymbols.containsKey(columnName), (String)"no symbol found for column '%s'", (Object)columnName);
        return this.columnSymbols.get(columnName);
    }

    public Type getTypeForSymbol(Symbol symbol) {
        return symbol.getType();
    }
}

