/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseTestParquetWithBloomFilters
extends AbstractTestQueryFramework {
    protected Path dataDirectory;
    private static final String COLUMN_NAME = "dataColumn";
    private static final List<Integer> TEST_VALUES = Arrays.asList(Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 3, 7, 10, 15);
    private static final int MISSING_VALUE = 0;

    @Test
    public void verifyBloomFilterEnabled() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.query(String.format("SHOW SESSION LIKE '%s.parquet_use_bloom_filter'", this.getSession().getCatalog().orElseThrow())))).skippingTypesCheck().matches(result -> result.getRowCount() == 1)).matches(result -> {
            String value = (String)((MaterializedRow)result.getMaterializedRows().get(0)).getField(1);
            return value.equals("true");
        });
    }

    @Test
    public void testBloomFilterRowGroupPruning() {
        CatalogSchemaTableName tableName = this.createParquetTableWithBloomFilter(COLUMN_NAME, TEST_VALUES);
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName, queryStats -> {}, results -> Assertions.assertThat((Collection)results.getOnlyColumnAsSet()).isEqualTo((Object)ImmutableSet.copyOf(TEST_VALUES)));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE dataColumn = 0", queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isEqualTo(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(0L);
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE dataColumn = " + TEST_VALUES.get(0), queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(1));
        this.assertQueryStats(BaseTestParquetWithBloomFilters.bloomFiltersDisabled(this.getSession()), "SELECT * FROM " + tableName + " WHERE dataColumn = 0", queryStats -> {
            Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
            Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
        }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private static Session bloomFiltersDisabled(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "parquet_use_bloom_filter", "false").build();
    }

    protected abstract CatalogSchemaTableName createParquetTableWithBloomFilter(String var1, List<Integer> var2);
}

