/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.client.IntervalDayTime;
import io.trino.client.IntervalYearMonth;
import io.trino.client.QueryData;
import io.trino.client.QueryStatusInfo;
import io.trino.client.Row;
import io.trino.client.RowField;
import io.trino.client.StatementStats;
import io.trino.client.Warning;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestingTrinoClient;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.ResultsSession;
import io.trino.type.IntervalDayTimeType;
import io.trino.type.IntervalYearMonthType;
import io.trino.type.IpAddressType;
import io.trino.type.JsonType;
import io.trino.type.SqlIntervalDayTime;
import io.trino.type.SqlIntervalYearMonth;
import io.trino.util.MoreLists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;

public class TestingTrinoClient
extends AbstractTestingTrinoClient<MaterializedResult> {
    private static final DateTimeFormatter timeWithZoneOffsetFormat = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().appendPattern("XXX").toFormatter();
    private static final DateTimeFormatter timestampFormat = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd().toFormatter();
    private static final DateTimeFormatter timestampWithTimeZoneFormat = new DateTimeFormatterBuilder().append(timestampFormat).appendPattern(" VV").toFormatter();

    public TestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession) {
        super(trinoServer, defaultSession);
    }

    public TestingTrinoClient(TestingTrinoServer trinoServer, Session defaultSession, OkHttpClient httpClient) {
        super(trinoServer, defaultSession, httpClient);
    }

    @Override
    protected ResultsSession<MaterializedResult> getResultSession(Session session) {
        return new MaterializedResultSession();
    }

    private static Function<List<Object>, MaterializedRow> dataToRow(List<Type> types) {
        return data -> {
            Preconditions.checkArgument((data.size() == types.size() ? 1 : 0) != 0, (Object)"columns size does not match types size");
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < data.size(); ++i) {
                Object value = data.get(i);
                Type type = (Type)types.get(i);
                row.add(TestingTrinoClient.convertToRowValue(type, value));
            }
            return new MaterializedRow(5, row);
        };
    }

    private static Object convertToRowValue(Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return value;
        }
        if (TinyintType.TINYINT.equals((Object)type)) {
            return ((Number)value).byteValue();
        }
        if (SmallintType.SMALLINT.equals((Object)type)) {
            return ((Number)value).shortValue();
        }
        if (IntegerType.INTEGER.equals((Object)type)) {
            return ((Number)value).intValue();
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return ((Number)value).longValue();
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return ((Number)value).doubleValue();
        }
        if (RealType.REAL.equals((Object)type)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (UuidType.UUID.equals((Object)type)) {
            return UUID.fromString((String)value);
        }
        if (IpAddressType.IPADDRESS.equals((Object)type)) {
            return value;
        }
        if (type instanceof VarcharType) {
            return value;
        }
        if (type instanceof CharType) {
            return value;
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return value;
        }
        if (DateType.DATE.equals((Object)type)) {
            return DateTimeFormatter.ISO_LOCAL_DATE.parse((CharSequence)((String)value), LocalDate::from);
        }
        if (type instanceof TimeType) {
            if (((TimeType)type).getPrecision() > 9) {
                return (String)value;
            }
            return DateTimeFormatter.ISO_LOCAL_TIME.parse((CharSequence)((String)value), LocalTime::from);
        }
        if (type instanceof TimeWithTimeZoneType) {
            if (((TimeWithTimeZoneType)type).getPrecision() > 9) {
                return (String)value;
            }
            return timeWithZoneOffsetFormat.parse((CharSequence)((String)value), OffsetTime::from);
        }
        if (type instanceof TimestampType) {
            if (((TimestampType)type).getPrecision() > 9) {
                return (String)value;
            }
            return timestampFormat.parse((CharSequence)((String)value), LocalDateTime::from);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            if (((TimestampWithTimeZoneType)type).getPrecision() > 9) {
                return (String)value;
            }
            return timestampWithTimeZoneFormat.parse((CharSequence)((String)value), ZonedDateTime::from);
        }
        if (IntervalDayTimeType.INTERVAL_DAY_TIME.equals((Object)type)) {
            return new SqlIntervalDayTime(IntervalDayTime.parseMillis((String)String.valueOf(value)));
        }
        if (IntervalYearMonthType.INTERVAL_YEAR_MONTH.equals((Object)type)) {
            return new SqlIntervalYearMonth(IntervalYearMonth.parseMonths((String)String.valueOf(value)));
        }
        if (type instanceof ArrayType) {
            return ((List)value).stream().map(element -> TestingTrinoClient.convertToRowValue(((ArrayType)type).getElementType(), element)).collect(Collectors.toList());
        }
        if (type instanceof MapType) {
            HashMap result = new HashMap();
            ((Map)value).forEach((k, v) -> result.put(TestingTrinoClient.convertToRowValue(((MapType)type).getKeyType(), k), TestingTrinoClient.convertToRowValue(((MapType)type).getValueType(), v)));
            return result;
        }
        if (type instanceof RowType) {
            List fieldTypes = type.getTypeParameters();
            List fieldValues = ((Row)value).getFields().stream().map(RowField::getValue).collect(Collectors.toList());
            return TestingTrinoClient.dataToRow(fieldTypes).apply(fieldValues);
        }
        if (type instanceof DecimalType) {
            return new BigDecimal((String)value);
        }
        if (type.getBaseName().equals("HyperLogLog")) {
            return value;
        }
        if (type.getBaseName().equals("Geometry")) {
            return value;
        }
        if (type.getBaseName().equals("SphericalGeography")) {
            return value;
        }
        if (type.getBaseName().equals("ObjectId")) {
            return value;
        }
        if (type.getBaseName().equals("Bogus")) {
            return value;
        }
        if (JsonType.JSON.equals((Object)type)) {
            return value;
        }
        throw new AssertionError((Object)("unhandled type: " + type));
    }

    private class MaterializedResultSession
    implements ResultsSession<MaterializedResult> {
        private final ImmutableList.Builder<MaterializedRow> rows = ImmutableList.builder();
        private final AtomicReference<List<Type>> types = new AtomicReference();
        private final AtomicReference<List<String>> columnNames = new AtomicReference();
        private final AtomicReference<Optional<String>> updateType = new AtomicReference(Optional.empty());
        private final AtomicReference<OptionalLong> updateCount = new AtomicReference<OptionalLong>(OptionalLong.empty());
        private final AtomicReference<List<Warning>> warnings = new AtomicReference<ImmutableList>(ImmutableList.of());
        private final AtomicReference<Optional<StatementStats>> statementStats = new AtomicReference(Optional.empty());

        private MaterializedResultSession() {
        }

        @Override
        public void setUpdateType(String type) {
            this.updateType.set(Optional.of(type));
        }

        @Override
        public void setUpdateCount(long count) {
            this.updateCount.set(OptionalLong.of(count));
        }

        @Override
        public void setWarnings(List<Warning> warnings) {
            this.warnings.set(warnings);
        }

        @Override
        public void setStatementStats(StatementStats statementStats) {
            this.statementStats.set(Optional.of(statementStats));
        }

        @Override
        public void addResults(QueryStatusInfo statusInfo, QueryData data) {
            if (this.types.get() == null && statusInfo.getColumns() != null) {
                this.types.set(TestingTrinoClient.this.getTypes(statusInfo.getColumns()));
                this.columnNames.set(TestingTrinoClient.this.getNames(statusInfo.getColumns()));
            }
            if (data.getData() != null) {
                Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"data received without types");
                this.rows.addAll((Iterable)MoreLists.mappedCopy((Iterable)data.getData(), TestingTrinoClient.dataToRow(this.types.get())));
            }
        }

        @Override
        public MaterializedResult build(Map<String, String> setSessionProperties, Set<String> resetSessionProperties) {
            Preconditions.checkState((this.types.get() != null ? 1 : 0) != 0, (Object)"never received types for the query");
            return new MaterializedResult((List)this.rows.build(), this.types.get(), this.columnNames.get(), setSessionProperties, resetSessionProperties, this.updateType.get(), this.updateCount.get(), this.warnings.get(), this.statementStats.get());
        }
    }
}

