/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.ProcedureTester;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class TestingProcedures {
    private final ProcedureTester tester;

    public TestingProcedures(ProcedureTester tester) {
        this.tester = Objects.requireNonNull(tester, "tester is null");
    }

    @UsedByGeneratedCode
    public void simple() {
        this.tester.recordCalled("simple", new Object[0]);
    }

    @UsedByGeneratedCode
    public void args(long x, double y, String z, boolean q) {
        this.tester.recordCalled("args", new Object[]{x, y, z, q});
    }

    @UsedByGeneratedCode
    public void nulls(Long x, String y) {
        this.tester.recordCalled("nulls", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void arrays(List<Long> x, List<String> y) {
        this.tester.recordCalled("arrays", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void nested(List<List<Long>> x) {
        this.tester.recordCalled("nested", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionFirst(ConnectorSession session, long x) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_first", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void sessionLast(String x, ConnectorSession session) {
        Objects.requireNonNull(session, "session is null");
        this.tester.recordCalled("session_last", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void exception() {
        this.tester.recordCalled("exception", new Object[0]);
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "test exception from procedure");
    }

    @UsedByGeneratedCode
    public void optionals(ConnectorSession session, String x) {
        this.tester.recordCalled("optionals", new Object[]{x});
    }

    @UsedByGeneratedCode
    public void optionals2(ConnectorSession session, String x, String y) {
        this.tester.recordCalled("optionals2", new Object[]{x, y});
    }

    @UsedByGeneratedCode
    public void optionals3(ConnectorSession session, String x, String y, String z) {
        this.tester.recordCalled("optionals3", new Object[]{x, y, z});
    }

    @UsedByGeneratedCode
    public void optionals4(ConnectorSession session, String x, String y, String z, String v) {
        this.tester.recordCalled("optionals4", new Object[]{x, y, z, v});
    }

    @UsedByGeneratedCode
    public void error() {
        this.tester.recordCalled("error", new Object[0]);
        throw new RuntimeException("test error from procedure");
    }

    @UsedByGeneratedCode
    public void names(ConnectorSession session, String x, String y, String z, String v) {
        this.tester.recordCalled("names", new Object[]{x, y, z, v});
    }

    public List<Procedure> getProcedures(String schema) {
        return ImmutableList.builder().add((Object)this.procedure(schema, "test_simple", "simple", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_lowercase_name", "simple", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "TEST_UPPERCASE_NAME", "simple", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_args", "args", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)BigintType.BIGINT), (Object)new Procedure.Argument("Y", (Type)DoubleType.DOUBLE), (Object)new Procedure.Argument("Z", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("Q", (Type)BooleanType.BOOLEAN)))).add((Object)this.procedure(schema, "test_nulls", "nulls", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)BigintType.BIGINT), (Object)new Procedure.Argument("Y", (Type)VarcharType.VARCHAR)))).add((Object)this.procedure(schema, "test_arrays", "arrays", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new Procedure.Argument("Y", (Type)new ArrayType((Type)VarcharType.VARCHAR))))).add((Object)this.procedure(schema, "test_nested", "nested", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)))))).add((Object)this.procedure(schema, "test_session_first", "sessionFirst", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)BigintType.BIGINT)))).add((Object)this.procedure(schema, "test_session_last", "sessionLast", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)VarcharType.VARCHAR)))).add((Object)this.procedure(schema, "test_optionals", "optionals", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)VarcharType.VARCHAR, false, (Object)"hello")))).add((Object)this.procedure(schema, "test_optionals2", "optionals2", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("Y", (Type)VarcharType.VARCHAR, false, (Object)"world")))).add((Object)this.procedure(schema, "test_optionals3", "optionals3", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)VarcharType.VARCHAR, false, (Object)"this"), (Object)new Procedure.Argument("Y", (Type)VarcharType.VARCHAR, false, (Object)"is"), (Object)new Procedure.Argument("Z", (Type)VarcharType.VARCHAR, false, (Object)"default")))).add((Object)this.procedure(schema, "test_optionals4", "optionals4", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("X", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("Y", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("Z", (Type)VarcharType.VARCHAR, false, (Object)"z default"), (Object)new Procedure.Argument("V", (Type)VarcharType.VARCHAR, false, (Object)"v default")))).add((Object)this.procedure(schema, "test_exception", "exception", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_error", "error", (List<Procedure.Argument>)ImmutableList.of())).add((Object)this.procedure(schema, "test_argument_names", "names", (List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("lower", true, (Type)VarcharType.VARCHAR, false, (Object)"a"), (Object)new Procedure.Argument("UPPER", true, (Type)VarcharType.VARCHAR, false, (Object)"b"), (Object)new Procedure.Argument("MixeD", true, (Type)VarcharType.VARCHAR, false, (Object)"c"), (Object)new Procedure.Argument("with space", true, (Type)VarcharType.VARCHAR, false, (Object)"d")))).build();
    }

    private Procedure procedure(String schema, String name, String methodName, List<Procedure.Argument> arguments) {
        return new Procedure(schema, name, arguments, this.handle(methodName));
    }

    private MethodHandle handle(String name) {
        List methods = Arrays.stream(this.getClass().getMethods()).filter(method -> method.getName().equals(name)).collect(Collectors.toList());
        Preconditions.checkArgument((!methods.isEmpty() ? 1 : 0) != 0, (String)"no matching methods: %s", (Object)name);
        Preconditions.checkArgument((methods.size() == 1 ? 1 : 0) != 0, (String)"multiple matching methods: %s", methods);
        return Reflection.methodHandle((Method)((Method)methods.get(0))).bindTo(this);
    }
}

